	.include	'eq.s'
	.include	'externs.s'

	.data
;*****************************************************************************************************
tlistds::
;background tiles
	dc.b	$00,$01,$02,$06,$0C,$0F,$0E,$0B,$0C,$0F,$0D,$04,$06,$0A,$09,$08,$03,$01,$07,$0D,$03,$05,$03,$05,$00,$01,$02,$04,$02,$01,$07,$0D
	dc.b	$03,$07,$0D,$02,$06,$0A,$08,$03,$01,$00,$01,$02,$00,$01,$04,$00,$01,$07,$0D,$05,$00,$02,$01,$06,$0A,$09,$08,$02,$01,$06,$0C,$0D
	dc.b	$00,$01,$06,$0A,$0C,$0E,$0B,$08,$03,$04,$05,$00,$02,$03,$07,$0F,$0E,$0B,$09,$0A,$09,$0C,$0E,$0B,$09,$08,$00,$04,$00,$03,$05,$00
	dc.b	$02,$00,$05,$06,$08,$05,$00,$05,$00,$02,$06,$09,$0C,$0F,$0D,$04,$07,$0E,$0B,$0A,$09,$0A,$08,$07,$0D,$01,$00,$07,$0D,$01,$00,$05
	dc.b	$03,$06,$09,$0A,$09,$08,$00,$03,$05,$06,$0C,$0D,$01,$02,$00,$06,$09,$0A,$08,$02,$03,$04,$05,$03,$06,$08,$07,$0F,$0D,$02,$01,$02
	dc.b	$03,$07,$0D,$00,$02,$07,$0D,$04,$05,$00,$01,$02,$01,$00,$01,$06,$09,$0A,$08,$03,$06,$09,$08,$00,$04,$00,$02,$00,$03,$06,$08,$03
	dc.b	$05,$00,$01,$02,$06,$08,$00,$02,$06,$0C,$0D,$01,$06,$08,$05,$00,$03,$01,$07,$0E,$0B,$0A,$0C,$0F,$0D,$05,$06,$09,$0A,$08,$02,$04
	dc.b	$07,$0D,$00,$01,$00,$02,$03,$07,$0E,$0B,$08,$03,$07,$0D,$00,$01,$02,$07,$0F,$0E,$0B,$0A,$08,$02,$00,$06,$08,$00,$05,$03,$01,$06
;end of desert level			   |--------end screen--------|
	dc.b	$08,$03,$01,$02,$00,$05,$06,$08,$03,$00,$01,$02,$03,$05,$06,$08,$03,$01,$04,$00,$07,$0F,$0D,$01,$06,$0C,$0D,$06,$0A,$08,$05,$06

frinfds::
;info for foreground objects
;data
	dc.l		dso00,dso01,dso02,dso03,dso04,0,0,0,0,0,0,0,0,0,0,0
;height
	dc.w		96,72,104,88,80,0,0,0,0,0,0,0,0,0,0,0
;width
	dc.w		320,160,224,192,160,0,0,0,0,0,0,0,0,0,0,0
;dwidth, iwidth
	dc.w		80,40,56,48,40,0,0,0,0,0,0,0,0,0,0,0
;ypos
	dc.w		SCRN_BOTTOM-192	;arch
	dc.w		SCRN_BOTTOM-144	;tri rock
	dc.w		SCRN_BOTTOM-208	;half arch
	dc.w		SCRN_BOTTOM-172	;pole
	dc.w		SCRN_BOTTOM-160	;tri rock
	dc.w		0,0,0,0,0,0,0,0,0,0,0

;foreground objects
;$FF means no tile in that spot
;numbers > $80 are flipped - subtract $80 to get the tile number to use
flistds::
	dc.b	$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$04
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$80,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$83,$FF,$FF,$FF,$FF,$FF,$80,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$82,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$84,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$83,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$82,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$81,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$04,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$80,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$81,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$84,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$83,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$82,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$81,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$80,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$84,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$83,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

;list of ground enemy/objects to create for each curbktile
glistds::
	dc.b	$FF,POPPY1,$FF,POPPY2,$FF,$FF,POPPY0,$FF,GEYSER,$FF,$FF,POPPY1,POPPY0,$FF,POPPY2,GEYSER			;16 objects per line
	dc.b	$FF,POPPY1,$FF,$FF,$FF,POPPY2,$FF,POPPY1,$FF,GEYSER,$FF,POPPY1,$FF,$FF,POPPY2,$FF
	dc.b	POPPY0,$FF,GEYSER,POPPY1,POPPY0,$FF,POPPY1,$FF,$FF,POPPY2,$FF,$FF,POPPY1,GEYSER,$FF,POPPY0
	dc.b	POPPY1,$FF,$FF,POPPY2,$FF,POPPY0,$FF,GEYSER,$FF,POPPY1,$FF,$FF,$FF,POPPY1,$FF,POPPY2
	dc.b	POPPY0,GEYSER,$FF,POPPY1,$FF,$FF,POPPY0,$FF,POPPY1,$FF,POPPY0,$FF,POPPY2,GEYSER,$FF,$FF
	dc.b	$FF,POPPY0,GEYSER,$FF,$FF,POPPY0,$FF,$FF,GEYSER,$FF,$FF,$FF,GEYSER,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,GEYSER,$FF,$FF,$FF,$FF,$FF,GEYSER,POPPY1,$FF,POPPY0
	dc.b	$FF,POPPY2,$FF,$FF,$FF,$FF,$FF,$FF,$FF,GEYSER,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	BALL,BALL,$FF,BALL,BALL,BALL,$FF,$FF,BALL,BALL,BALL,BALL,$FF,BALL,$FF,$FF
	dc.b	BALL,BALL,BALL,$FF,BALL,$FF,$FF,BALL,$FF,BALL,$FF,BALL,$FF,BALL,BALL,$FF
	dc.b	BALL,$FF,BALL,BALL,$FF,BALL,BALL,$FF,BALL,BALL,$FF,BALL,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,STATION,$FF,$FF,$FF,$FF,POPPY0,$FF,POPPY1,$FF,$FF,GEYSER,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,POPPY0,$FF,$FF,$FF,GEYSER,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,POPPY0,$FF,$FF,$FF,GEYSER,$FF,$FF,$FF,$FF,POPPY2,$FF,$FF,$FF
	dc.b	$FF,$FF,POPPY2,GEYSER,POPPY1,$FF,$FF,$FF,$FF,POPPY0,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;256


;formations for desert level
formsds::
	dc.b	$FF,$FF,$FF,$FF,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,  2,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,  0
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,  2,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,  3,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,  0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,  3,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,  4,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,  5,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,  6,$FF
	dc.b	$FF,$FF,$FF,  1,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,  3,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,  7,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,  8,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	  9,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

;enemies for desert level		32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;turborat
;scorpb
;scorps
;fbug
;vult
;ball
elistds::
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,      99,      99,      99,TURBORAT,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG
	dc.b	      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,      99,      99,      99,      99,TURBORAT,      99,      99
	dc.b	      99,      99,TURBORAT,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,      99,TURBORAT,      99
	dc.b	      99,      99,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99
	dc.b	      99,TURBORAT,      99,      99,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,TURBORAT,      99
	dc.b	      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99
	dc.b	    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,TURBORAT,      99,    FBUG
	dc.b	TURBORAT,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,TURBORAT,      99,      99,      99,    FBUG,      99
	dc.b	SCORPSML,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99
	dc.b	      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,SCORPSML,      99,      99
	dc.b	    FBUG,      99,      99,SCORPBIG,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99
	dc.b	    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,    FBUG,      99
	dc.b	      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99
	dc.b	      99,      99,SCORPSML,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,    FBUG,      99,      99
	dc.b	      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,SCORPSML,    FBUG,      99,      99
	dc.b	      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,SCORPSML
	dc.b	      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,SCORPBIG
	dc.b	      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,SCORPSML,      99,      99
	dc.b	    FBUG,      99,      99,      99,      99,    FBUG,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,    FBUG
	dc.b	      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,    FBUG,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,    FBUG,      99,      99
	dc.b	      99,SCORPBIG,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,SCORPSML,      99,      99,      99,    FBUG
	dc.b	      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99
	dc.b	      99,      99,    FBUG,      99,      99,      99,SCORPSML,      99,      99,      99,      99,    FBUG,      99,      99,    FBUG,      99
	dc.b	    FBUG,      99,      99,      99,    FBUG,      99,SCORPSML,      99,      99,      99,    FBUG,      99,      99,      99,      99,    FBUG
	dc.b	      99,      99,    FBUG,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99
	dc.b	      99,    FBUG,      99,      99,      99,      99,    FBUG,      99,      99,      99,    FBUG,      99,      99,      99,      99,    FBUG
	dc.b	      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,    FBUG,      99,      99,      99,    FBUG,      99,      99,      99,      99,      99,      99,    FBUG,      99,      99
	dc.b	      99,    FBUG,      99,      99,      99,    FBUG,      99,      99,      99,    FBUG,      99,    VULT,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,    FBUG,      99,      99,      99,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,    VULT
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,    VULT,      99,      99,      99,    FBUG
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,      99,      99,    VULT,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,    VULT,      99,    FBUG,      99,      99,      99,      99,      99,      99,    VULT,      99,      99
	dc.b	      99,TURBORAT,      99,      99,      99,      99,      99,      99,      99,      99,    VULT,      99,TURBORAT,      99,      99,      99
	dc.b	      99,      99,    VULT,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,    VULT,      99,      99,TURBORAT
	dc.b	      99,      99,      99,    VULT,      99,      99,      99,      99,      99,      99,    VULT,      99,      99,    FBUG,      99,      99
	dc.b	    VULT,      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,      99,    VULT,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,    VULT,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,    VULT,      99,      99
	dc.b	      99,SCORPSML,      99,      99,      99,      99,      99,TURBORAT,      99,      99,      99,      99,      99,      99,    VULT,      99
	dc.b	      99,SCORPSML,      99,      99,      99,TURBORAT,      99,      99,      99,    FBUG,      99,      99,      99,      99,SCORPBIG,      99
	dc.b	      99,      99,      99,      99,      99,      99,    FBUG,SCORPSML,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,    FBUG,      99,      99,      99,SCORPSML,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,SCORPSML,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	SCORPSML,      99,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99,TURBORAT,      99,      99,SCORPSML,      99
	dc.b	      99,    FBUG,      99,      99,      99,      99,      99,      99,    VULT,      99,      99,      99,SCORPSML,      99,      99,      99
	dc.b	      99,      99,      99,      99,    FBUG,      99,      99,SCORPBIG,      99,      99,SCORPSML,      99,      99,      99,      99,      99
	dc.b	    FBUG,SCORPSML,      99,      99,      99,      99,      99,      99,      99,SCORPSML,      99,      99,      99,      99,SCORPSML,      99
	dc.b	      99,      99,      99,      99,SCORPSML,      99,      99,      99,      99,SCORPSML,      99,TURBORAT,      99,      99,      99,SCORPSML
	dc.b	      99,    FBUG,      99,      99,      99,      99,SCORPSML,    FBUG,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99


;*****************************************************************************************************
tlistsw::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$0D,$02,$03,$0C,$01,$0E,$00,$0E,$05,$0C,$0D,$02,$0D,$0F,$01,$0F,$0D,$03,$06,$0A,$0B,$0C,$01,$0D,$01,$03,$00,$01,$0E,$06,$07
	dc.b	$0A,$09,$08,$09,$0B,$05,$04,$0C,$01,$0F,$01,$0D,$02,$0E,$04,$06,$07,$0A,$07,$0A,$07,$0B,$00,$02,$01,$0E,$04,$05,$06,$0A,$0B,$00
	dc.b	$0D,$01,$02,$01,$02,$0E,$06,$07,$0A,$08,$09,$08,$0A,$08,$09,$07,$09,$0A,$07,$0A,$0B,$00,$01,$0D,$0F,$02,$03,$05,$00,$01,$0D,$0E
	dc.b	$04,$0C,$02,$0F,$01,$03,$00,$0D,$03,$0C,$0D,$0E,$0C,$02,$01,$02,$0F,$01,$0D,$01,$0D,$02,$03,$0C,$01,$0F,$01,$0E,$04,$05,$06,$07
	dc.b	$0B,$0C,$02,$0E,$05,$06,$09,$07,$0A,$07,$09,$0B,$05,$06,$0A,$08,$09,$0B,$00,$0F,$0D,$0F,$02,$01,$0D,$02,$0D,$02,$03,$04,$00,$01
	dc.b	$0E,$00,$0D,$01,$0F,$0D,$0F,$01,$0F,$02,$0E,$00,$0E,$06,$0A,$08,$07,$09,$0A,$08,$07,$0A,$07,$08,$0A,$09,$0A,$07,$0A,$08,$09,$07
	dc.b	$0A,$07,$0B,$04,$05,$00,$03,$00,$02,$0E,$04,$0C,$01,$0F,$02,$0D,$0F,$01,$0F,$02,$0D,$0F,$02,$01,$02,$0D,$02,$03,$00,$02,$0F,$02
	dc.b	$01,$03,$05,$0C,$02,$0D,$0E,$04,$06,$09,$0A,$07,$0B,$05,$06,$0A,$08,$07,$09,$0A,$08,$07,$08,$0A,$07,$0B,$06,$0A,$0B,$06,$0A,$08
;end of swamp level
	dc.b	$09,$0B,$05,$04,$0C,$01,$0F,$01,$0D,$02,$0E,$04,$06,$07,$0A,$07,$0A,$07,$0B,$00,$02,$01,$0E,$04,$05,$06,$0A,$0B,$00,$0D,$02,$03

frinfsw::
;info for foreground objects
;data
	dc.l		moss0,moss0,moss0,moss0,mossrk0,mossrk0,mossrk0,mossrk0,stump0,stump0,stump0,stump0,tree0,0,0,0
;height
	dc.w		96,96,96,96,144,144,144,144,144,144,144,144,288,0,0,0
;width
	dc.w		128,128,128,128,192,192,192,192,160,160,160,160,160,0,0,0
;dwidth, iwidth
	dc.w		32,32,32,32,48,48,48,48,40,40,40,40,40,0,0,0
;ypos
	dc.w		SCRN_BOTTOM-192	;moss
	dc.w		SCRN_BOTTOM-168	;moss
	dc.w		SCRN_BOTTOM-144	;moss
	dc.w		SCRN_BOTTOM-122	;moss
	dc.w		SCRN_BOTTOM-288	;moss rock
	dc.w		SCRN_BOTTOM-230	;moss rock
	dc.w		SCRN_BOTTOM-170	;moss rock
	dc.w		SCRN_BOTTOM-120	;moss rock
	dc.w		SCRN_BOTTOM-288	;stump
	dc.w		SCRN_BOTTOM-220	;stump
	dc.w		SCRN_BOTTOM-164	;stump
	dc.w		SCRN_BOTTOM-124	;stump
	dc.w		SCRN_BOTTOM-572	;tree
	dc.w		0,0,0

;foreground objects
;$FF means no tile in that spot
;numbers > $80 are flipped - subtract $80 to get the tile number to use
flistsw::
	dc.b	$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$FF,$FF,$08,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$0B,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$07,$FF,$FF,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$06,$FF,$FF,$FF,$FF,$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$03,$FF,$FF,$FF,$09,$FF,$FF,$FF,$0C,$FF,$FF,$0B,$FF,$FF,$FF,$08,$FF,$FF,$FF,$02,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF,$08,$FF,$FF,$FF,$FF,$FF,$FF,$06,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$06,$FF,$FF,$FF,$FF,$FF,$FF,$0B,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$05,$FF,$FF,$FF,$FF,$FF,$FF,$0A,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$FF,$FF,$0A,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$07,$FF,$FF,$FF,$FF,$FF,$FF,$0B,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$05,$FF,$FF,$FF,$FF,$FF,$FF,$08,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$03,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$06,$FF,$FF,$FF,$FF,$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$09,$FF,$FF
	dc.b	$FF,$FF,$FF,$07,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$0A,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$06,$FF,$FF,$FF,$FF,$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$FF,$FF,$08,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$0B,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$05,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF


;list of ground enemy/objects to create for each curbktile
glistsw::
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,SPORE,$FF			;16 objects per line
	dc.b	$FF,$FF,FERN,$FF,SPORE,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,FERN,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,SPORE
	dc.b	$FF,$FF,FERN,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,FERN,$FF,$FF,SPORE
	dc.b	$FF,$FF,$FF,SPORE,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	FERN,$FF,$FF,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,SPORE,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,SPORE
	dc.b	$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,$FF,SPORE,$FF,$FF,$FF,FERN,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,SPORE,$FF,$FF,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF
	dc.b	STATION,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,SPORE,FERN,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,FERN,$FF,$FF,$FF,$FF,$FF,SPORE,$FF,$FF,$FF,$FF,FERN,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,$FF
	dc.b	FERN,$FF,$FF,$FF,$FF,SPORE,$FF,$FF,$FF,$FF,FERN,$FF,$FF,$FF,SPORE,$FF
	dc.b	$FF,$FF,FERN,$FF,$FF,$FF,$FF,SPORE,$FF,$FF,FERN,$FF,$FF,$FF,$FF,SPORE
	dc.b	$FF,$FF,$FF,FERN,$FF,$FF,$FF,$FF,$FF,SPORE,$FF,$FF,FERN,$FF,$FF,$FF
	dc.b	FERN,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;256

;enemies for swamp level		32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;pillbug
;seymour
;batskull
;flower
;gundino
;kilrun
;sadmask
;firefly
;buggy
elistsw::
	dc.b	      99,   BUGGY,      99,      99,      99,      99,      99,      99,      99,   BUGGY,      99,      99,      99,      99,      99,      99
	dc.b	      99,   BUGGY,      99,      99,      99,      99,      99,      99,      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99
	dc.b	      99,   BUGGY,      99,      99,      99,      99,      99,      99,      99,   BUGGY,      99,      99,      99,      99,      99,      99
	dc.b	      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99,      99,      99,      99,   BUGGY
	dc.b	      99,      99,      99,      99,      99,   BUGGY,      99,      99,      99,      99,      99,   BUGGY,      99,      99,      99,      99
	dc.b	      99,   BUGGY,      99,      99,      99,      99,      99,   BUGGY,      99,      99,      99,      99,      99,   BUGGY,      99,      99
	dc.b	      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99,   BUGGY,      99,      99,   BUGGY
	dc.b	      99,      99,      99, GUNDINO, PILLBUG,      99,      99,      99, PILLBUG,      99,      99, SEYMOUR,      99,      99,      99,   BUGGY
	dc.b	 FIREFLY,      99,      99,      99, PILLBUG,      99,      99,      99,      99, PILLBUG, SEYMOUR,      99,      99, GUNDINO, PILLBUG,      99
	dc.b	      99,      99,  FLOWER,      99,      99, FIREFLY,      99, SEYMOUR,      99,   BUGGY,      99,  FLOWER,      99,      99, PILLBUG, SADMASK
	dc.b	 PILLBUG,      99,      99,  FLOWER,      99,      99, GUNDINO,      99,      99,  FLOWER, PILLBUG,      99, SEYMOUR,      99,      99,  FLOWER
	dc.b	 PILLBUG,      99, SEYMOUR,      99,      99, GUNDINO, PILLBUG,      99,      99,  FLOWER,      99, PILLBUG,      99,      99,      99, SEYMOUR
	dc.b	      99,      99, GUNDINO,      99,      99,  FLOWER,BATSKULL,      99,      99,      99,      99, SADMASK, PILLBUG,      99, FIREFLY,      99
	dc.b	      99,  FLOWER, PILLBUG,      99,      99,      99,      99, PILLBUG, SEYMOUR,      99,      99, GUNDINO,   BUGGY,      99,  FLOWER,BATSKULL
	dc.b	      99,      99,      99, PILLBUG, SEYMOUR,      99, PILLBUG, GUNDINO,      99,      99,  FLOWER,      99,      99,      99, PILLBUG,      99
	dc.b	 SEYMOUR,      99,      99, GUNDINO,      99,      99,  FLOWER,  KILRUN,      99,      99, PILLBUG,      99,      99, SEYMOUR,      99,      99
	dc.b	      99,BATSKULL,      99,      99,      99,      99,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99
	dc.b	      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99
	dc.b	      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99
	dc.b	      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99
	dc.b	      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99,      99,BATSKULL,      99,      99
	dc.b	      99,BATSKULL,      99,      99,      99,      99,BATSKULL,      99,      99,      99,      99,      99,BATSKULL,      99,      99,BATSKULL
	dc.b	      99,      99,      99,  FLOWER,      99,BATSKULL,      99, PILLBUG,      99, SEYMOUR,      99,      99,      99, GUNDINO,      99,      99
	dc.b	  FLOWER, PILLBUG,      99,      99,      99,      99, SEYMOUR,      99, PILLBUG, GUNDINO,      99,      99,      99,BATSKULL, PILLBUG,      99
	dc.b	      99,      99,      99,      99, PILLBUG, SEYMOUR,      99,      99,      99,BATSKULL, PILLBUG,      99,      99,  FLOWER,   BUGGY,      99
	dc.b	 PILLBUG,      99,      99, FIREFLY,      99, SEYMOUR,      99,      99,      99,      99,      99, SEYMOUR, PILLBUG,      99,      99,      99
	dc.b	 GUNDINO,      99,  FLOWER,      99,BATSKULL,      99,      99,      99,      99, SADMASK, PILLBUG,      99,      99,      99, GUNDINO, SEYMOUR
	dc.b	 PILLBUG,      99,      99,      99, PILLBUG,      99,BATSKULL,      99,  FLOWER,      99,      99, FIREFLY,      99,      99, PILLBUG, PILLBUG
	dc.b	      99, SEYMOUR,   BUGGY,      99,      99,  KILRUN, PILLBUG,      99,      99, PILLBUG,      99,  FLOWER,      99,      99,      99,      99
	dc.b	      99, GUNDINO,      99, SEYMOUR,      99, PILLBUG,      99,      99,      99,      99, PILLBUG,      99,  FLOWER,      99,      99,      99
	dc.b	      99, PILLBUG,      99,      99, SEYMOUR,      99,      99,      99,      99,      99,      99,      99,      99,  FLOWER, PILLBUG,      99
	dc.b	   BUGGY,      99,      99, PILLBUG,      99, SEYMOUR,      99,      99,      99,      99,      99,      99,  FLOWER, PILLBUG,      99,      99
	dc.b	      99,      99,  FLOWER,      99,      99, FIREFLY,      99, SEYMOUR,      99,      99,BATSKULL,  FLOWER,      99,      99, PILLBUG, SADMASK
	dc.b	      99,      99,      99, SEYMOUR, PILLBUG,      99,      99,      99,      99,      99, PILLBUG,  FLOWER,      99,      99,      99,      99
	dc.b	      99,      99,  FLOWER, PILLBUG,      99,      99,      99,      99,  FLOWER,      99,      99,   BUGGY, PILLBUG,      99,      99,      99
	dc.b	 PILLBUG, SEYMOUR,      99,      99, SADMASK,      99,  FLOWER,      99,      99,      99, SEYMOUR,      99,      99,      99,      99,  FLOWER
	dc.b	 PILLBUG,      99,      99,      99, SEYMOUR,      99, PILLBUG,      99,      99,      99, PILLBUG,      99,  FLOWER,      99,   BUGGY,      99
	dc.b	      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99
	dc.b	      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99,      99,   BUGGY,      99,      99
	dc.b	      99,  FLOWER, PILLBUG,      99,      99,      99,      99,BATSKULL,      99, SEYMOUR,      99,      99,      99,   BUGGY, PILLBUG,      99
	dc.b	  FLOWER,      99,      99,      99, PILLBUG,      99,      99,      99, SEYMOUR,      99, PILLBUG,      99,      99,      99,      99,  FLOWER
	dc.b	      99, PILLBUG, GUNDINO,      99,      99,  FLOWER,BATSKULL,      99,      99,      99,      99, SADMASK,      99,      99, FIREFLY,      99
	dc.b	      99, PILLBUG,      99,      99,      99,      99, PILLBUG, SEYMOUR,      99,      99, PILLBUG,      99, PILLBUG,      99,      99, PILLBUG
	dc.b	  FLOWER,      99,      99,      99, PILLBUG,      99,      99,   BUGGY, SEYMOUR,      99, PILLBUG,      99,      99,      99,      99,  FLOWER
	dc.b	      99,      99, PILLBUG,      99,      99,      99, SEYMOUR,      99,      99,      99,      99,      99,      99,  FLOWER, FIREFLY,      99
	dc.b	 PILLBUG,      99,      99, SEYMOUR,      99,      99,      99,      99,      99,  FLOWER,      99, PILLBUG,      99,   BUGGY,      99, SADMASK
	dc.b	      99,      99,      99,      99,      99,  FLOWER, PILLBUG,      99,      99,      99, PILLBUG,      99,      99,      99, SEYMOUR, PILLBUG
	dc.b	      99, PILLBUG,      99,      99,      99,      99,      99,  FLOWER,      99,      99,   BUGGY,      99,      99,      99,      99, SEYMOUR
	dc.b	 PILLBUG,      99,      99, PILLBUG,      99,      99,      99,  FLOWER,      99, PILLBUG,      99,      99, PILLBUG,      99, SEYMOUR,      99
	dc.b	      99,      99, PILLBUG,      99,      99, PILLBUG,      99,      99,  FLOWER,      99, PILLBUG,      99,      99,      99,      99, SADMASK
	dc.b	 PILLBUG,      99,   BUGGY, PILLBUG,      99,      99,      99,  FLOWER,      99,      99, PILLBUG,      99,      99,   BUGGY,      99, SEYMOUR
	dc.b	      99, PILLBUG,      99,      99,      99,      99, PILLBUG,  FLOWER,      99,      99,      99, PILLBUG,      99, PILLBUG,      99, SEYMOUR
	dc.b	      99,      99,      99,      99, PILLBUG,  FLOWER,      99,      99, PILLBUG,      99,      99, PILLBUG,      99, GUNDINO, SADMASK,      99
	dc.b	      99, PILLBUG,      99,      99, PILLBUG,   BUGGY,      99,      99, PILLBUG,  FLOWER,      99,      99,      99,      99, PILLBUG,      99
	dc.b	 SEYMOUR,      99,      99,      99, PILLBUG,      99,      99, PILLBUG,      99,      99,  FLOWER,      99, PILLBUG,      99,      99,      99
	dc.b	 PILLBUG,      99,      99, SEYMOUR,      99,      99, PILLBUG,      99,      99,      99, PILLBUG,  FLOWER,   BUGGY,      99,      99,      99
	dc.b	 PILLBUG,      99,      99, PILLBUG, SEYMOUR,      99,      99,      99, PILLBUG,      99,  FLOWER,      99,      99,      99, PILLBUG,      99
	dc.b	 SEYMOUR,      99,      99,      99, PILLBUG,      99,      99,  FLOWER, PILLBUG,      99,      99, PILLBUG,      99,      99,      99, SEYMOUR
	dc.b	      99,      99, PILLBUG,      99,      99,  FLOWER, PILLBUG,      99,      99,      99,      99, SADMASK, PILLBUG,      99,      99,      99
	dc.b	 SEYMOUR,      99, PILLBUG,      99,   BUGGY,      99,      99,  FLOWER, PILLBUG,      99,      99,      99, PILLBUG,      99,      99,      99
	dc.b	 SEYMOUR, PILLBUG,      99,      99,      99,      99, PILLBUG,      99,  FLOWER,      99,      99,      99, PILLBUG,      99,      99,      99
	dc.b	 SEYMOUR, PILLBUG,      99,      99,      99,      99,      99,  FLOWER, PILLBUG,      99,      99,      99,      99,      99, PILLBUG, SADMASK
	dc.b	      99,      99,      99, PILLBUG, FIREFLY,      99,  FLOWER, PILLBUG,      99,      99,      99, PILLBUG,      99, SEYMOUR,      99,      99
	dc.b	      99, PILLBUG,      99,      99,  FLOWER, PILLBUG,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99


;*****************************************************************************************************
tlistair::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F

;list of ground enemy/objects to create for each curbktile
glistair::
	dc.b	$FF,$FF,$FF,$FF,BLOCKB,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF			;16 objects per line
	dc.b	$FF,BLOCKB,$FF,$FF,$FF,$FF,$FF,BLOCKM,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF
	dc.b	$FF,BLOCKB,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF,BLOCKB,$FF,$FF,$FF
	dc.b	$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,BLOCKM,$FF,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,BLOCKB,$FF,$FF,$FF,BLOCKM,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,BLOCKB,$FF,$FF,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF
	dc.b	BLOCKS,$FF,$FF,$FF,BLOCKM,$FF,$FF,$FF,$FF,$FF,BLOCKB,$FF,$FF,$FF,$FF,$FF
	dc.b	STATION,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,BLOCKM,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,BLOCKB,$FF,$FF,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF
	dc.b	$FF,BLOCKB,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,BLOCKM,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,BLOCKB,$FF,$FF,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,BLOCKB,$FF,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF,BLOCKS,$FF
	dc.b	$FF,BLOCKB,$FF,$FF,$FF,$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF,$FF,BLOCKM,$FF,$FF
	dc.b	$FF,BLOCKS,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;256

;enemies for air level			32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;spinner
;hummingbird
;baby
elistair::
	dc.b	      99,      99,      99,      99, SPINNER,      99,      99,      99,      99,      99, SPINNER,      99,      99,      99,      99,      99
	dc.b	 SPINNER,      99,      99,      99,      99, SPINNER,      99,      99,      99,      99, SPINNER,      99,      99, SPINNER,      99,      99
	dc.b	 SPINNER,      99,      99,      99,      99,      99,      99,      99,    HUMM,      99,    BABY,      99,      99,      99,    HUMM, SPINNER
	dc.b	      99,      99,      99,      99,      99,      99,    HUMM,      99,      99,      99,      99,    HUMM,      99,      99,      99,      99
	dc.b	    HUMM,      99,      99,      99,      99, SPINNER,  DRAGON,      99,    HUMM,      99,    BABY,      99,      99,      99,      99,    HUMM
	dc.b	      99, SPINNER,      99,      99,      99,      99,      99,    HUMM,      99,      99,      99,      99,      99,    HUMM,      99,  DRAGON
	dc.b	      99,      99,      99, SPINNER,      99,      99,    HUMM,      99,      99,      99,      99,    BABY,    HUMM,      99,      99,      99
	dc.b	 SPINNER,      99,      99,      99,    HUMM,      99,      99,      99,    BABY,      99,      99,      99,      99,      99,  DRAGON,      99
	dc.b	      99,      99,      99,      99,    HUMM,      99,      99,    HUMM,      99,      99,      99, SPINNER,      99,      99,    HUMM,      99
	dc.b	      99,      99,    BABY,    HUMM,      99,      99,    HUMM,      99,    HUMM, SPINNER,      99,      99,      99,      99,      99,    BABY
	dc.b	      99,      99,      99,      99,      99,    HUMM,      99,      99,    BABY,      99, SPINNER,      99,      99,      99,    HUMM,      99
	dc.b	      99,      99,      99,    HUMM,      99,      99,      99,      99, SPINNER,      99,      99,    BABY,      99,    HUMM,      99,      99
	dc.b	      99,      99,      99,    HUMM,      99,      99, SPINNER,      99,      99,      99, SPINNER,      99,      99,      99,    HUMM, SPINNER
	dc.b	      99, SPINNER,      99, SPINNER,      99,      99,      99,    BABY,      99,      99,    HUMM,      99,      99, SPINNER,      99,    HUMM
	dc.b	 SPINNER,      99,      99,      99, SPINNER,      99, SPINNER,      99,      99, SPINNER,      99,      99,      99,    HUMM, SPINNER,    BABY
	dc.b	      99, SPINNER,      99, SPINNER,      99,    HUMM, SPINNER,    BABY,      99,      99,      99,      99,    HUMM,      99,      99,  DRAGON
	dc.b	      99,      99,      99,    BABY,      99,      99, SPINNER, SPINNER,      99, SPINNER, SPINNER,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,    HUMM,      99,      99, SPINNER,      99,      99,    HUMM,      99,    BABY,      99,      99,    HUMM
	dc.b	      99,      99,      99,      99,      99,      99,    HUMM,      99,      99, SPINNER,      99,      99,      99,      99,      99,    BABY
	dc.b	    HUMM,      99,      99,      99,    HUMM,    HUMM,      99,      99,      99,      99,      99, SPINNER,  DRAGON,      99,      99,      99
	dc.b	    HUMM,      99,      99,      99,      99,      99,    BABY,      99,      99,      99, SPINNER,      99,      99,    HUMM,      99,      99
	dc.b	      99,      99,      99,      99,    BABY,      99,    HUMM,      99, SPINNER,      99,    HUMM,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,    BABY,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99, SPINNER,    HUMM,      99,    HUMM,      99,    HUMM,    HUMM,    HUMM,      99,    HUMM,    HUMM,    HUMM,    HUMM,      99, SPINNER
	dc.b	    HUMM,      99,    BABY,      99,      99,      99,    BABY,    HUMM,      99, SPINNER,      99,      99,    HUMM,      99,      99,    HUMM
	dc.b	    HUMM,      99,    HUMM,      99,    HUMM,      99,    HUMM,      99,    HUMM,      99,    HUMM,      99, SPINNER,    HUMM,      99,    HUMM
	dc.b	    HUMM,      99,    BABY,    HUMM,      99,  DRAGON,      99,      99,    HUMM,      99,    BABY,    HUMM,      99,      99,    HUMM,      99
	dc.b	    HUMM,      99,    HUMM,      99,    HUMM,      99,    HUMM,      99,    HUMM,    HUMM,      99,      99,    BABY,      99,    HUMM,      99
	dc.b	    HUMM,      99,    HUMM,      99,      99, SPINNER,    HUMM,      99,    HUMM,      99,    HUMM,      99,    HUMM,    HUMM,      99,    HUMM
	dc.b	      99,    BABY,      99,      99,      99,    HUMM,      99,      99,    HUMM,      99,    HUMM,      99,      99,      99,    BABY,    HUMM
	dc.b	      99,      99,    HUMM,      99,      99,      99,    HUMM,      99,      99,    HUMM,    HUMM,      99,      99,      99,      99,    BABY
	dc.b	      99,      99,      99,    HUMM,      99,      99,      99,      99,      99,    BABY,      99,      99,    HUMM,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,    HUMM,      99,      99,      99,      99,    BABY,      99, SPINNER,      99, SPINNER
	dc.b	 SPINNER, SPINNER,      99, SPINNER,      99, SPINNER,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	 SPINNER,      99,      99,      99,      99,      99,      99,      99,    HUMM, SPINNER,      99, SPINNER,    HUMM, SPINNER,      99,      99
	dc.b	 SPINNER,      99,      99,    HUMM,  DRAGON, SPINNER,      99,    HUMM,      99,  DRAGON, SPINNER,      99,      99,      99,      99, SPINNER
	dc.b	      99,      99,      99, SPINNER,      99,      99,      99,      99,      99,    BABY,      99,      99,    HUMM,      99, SPINNER,      99
	dc.b	      99,      99,      99,    BABY,      99,      99,      99,    HUMM,      99,      99, SPINNER,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99, SPINNER,      99,      99,      99,      99,    HUMM,      99,    HUMM
	dc.b	      99,    BABY,      99,      99, SPINNER,  DRAGON,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99, SPINNER,      99,      99,      99,      99,      99,      99,      99,    HUMM,    HUMM, SPINNER,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99, SPINNER,      99,    BABY,      99,      99,      99,      99,      99,      99,      99,    HUMM
	dc.b	    HUMM, SPINNER,      99,    HUMM,      99,    HUMM,      99,      99,      99, SPINNER,      99,      99,      99,      99,    HUMM,      99
	dc.b	      99,      99,      99,      99, SPINNER,      99,      99,      99,      99,      99,      99,      99,      99,    HUMM,      99,      99
	dc.b	      99, SPINNER,      99,      99,  DRAGON,    BABY,    HUMM,      99,      99,      99,      99,      99,    HUMM,      99,      99,      99
	dc.b	 SPINNER,  DRAGON,      99,  DRAGON,      99,      99,      99,      99, SPINNER,      99,    HUMM,    HUMM,      99,    HUMM,      99, SPINNER
	dc.b	    HUMM,      99,      99,      99,      99,      99, SPINNER,      99,      99,  DRAGON,    HUMM,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,    BABY,    HUMM,    HUMM,    HUMM,    HUMM,      99,      99,      99,      99
	dc.b	      99, SPINNER,      99,      99,      99,    HUMM,      99,    HUMM,      99,    HUMM,      99,      99,  DRAGON,      99, SPINNER,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99, SPINNER,      99,      99,      99,      99,      99,  DRAGON,    HUMM,      99
	dc.b	  DRAGON,      99,  DRAGON,      99,      99,      99,      99, SPINNER,      99,      99,    BABY,    HUMM,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99, SPINNER,      99,    HUMM,    HUMM,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99, SPINNER,      99,    HUMM,      99,      99,      99,      99,  DRAGON,      99,    HUMM, SPINNER
	dc.b	      99,      99,      99,      99,      99,      99,    HUMM,      99,      99,      99, SPINNER,      99,      99,      99,      99,      99
	dc.b	    HUMM,    HUMM,      99,      99,      99,      99, SPINNER,      99,      99,      99,      99,    HUMM,      99,      99,      99,    BABY
	dc.b	  DRAGON,      99,      99,    HUMM, SPINNER,      99,      99,      99,      99,      99,    HUMM,      99,      99,  DRAGON,      99,      99
	dc.b	      99,      99, SPINNER,      99,      99,      99,    HUMM,      99,      99,      99,    HUMM,      99,      99, SPINNER,      99,      99
	dc.b	  DRAGON,      99,      99,      99,      99,      99,      99,    HUMM, SPINNER,      99,      99,      99,      99,  DRAGON,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99, SPINNER,    HUMM,      99,      99,      99,      99,    HUMM,      99,      99,    BABY
	dc.b	      99,      99,      99,      99,  DRAGON, SPINNER,      99,      99,      99,      99,    HUMM,      99,      99,      99,      99,    HUMM
	dc.b	 SPINNER,      99,      99,      99,      99,      99,      99,    HUMM,      99,  DRAGON,      99,    HUMM,      99,      99,      99, SPINNER
	dc.b	      99,      99,      99,      99,      99,    HUMM,    HUMM,      99,      99,      99,    HUMM,      99,      99, SPINNER,      99,      99
	dc.b	      99,      99,      99,  DRAGON,    HUMM,      99,      99,      99,    BABY,    HUMM,      99,      99,    BABY,      99,    HUMM,      99
	dc.b	      99,      99,      99, SPINNER,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99

;*****************************************************************************************************
tlistcv::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07
;end of cave level
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07,$00,$01,$02,$03,$04,$05,$06,$07

;info for foreground objects
frinfcv::
;data
	dc.l		cvrock00,cvrock01,cvrock00,cvrock01,cvrock00,cvrock01,cvrock00,cvrock01,cvrock02,cvrock03,cvrock02,cvrock03,cvrock02,cvrock03,cvrock02,cvrock03
;height
	dc.w		128,128,128,128,128,128,128,128,88,88,88,88,88,88,88,88
;width
	dc.w		160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160
;dwidth, iwi|dth
	dc.w		40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
;ypos
	dc.w		SCRN_TOP				;0	160 x 128
	dc.w		SCRN_BOTTOM-250		;0
	dc.w		SCRN_TOP-50			;0
	dc.w		SCRN_BOTTOM-200		;0
	dc.w		SCRN_TOP-100			;0
	dc.w		SCRN_BOTTOM-140		;0
	dc.w		SCRN_TOP-150			;0
	dc.w		SCRN_BOTTOM-100		;0
	dc.w		SCRN_TOP				;1	160 x 88
	dc.w		SCRN_BOTTOM-170		;1
	dc.w		SCRN_TOP-40			;1
	dc.w		SCRN_BOTTOM-130		;1
	dc.w		SCRN_TOP-70			;1
	dc.w		SCRN_BOTTOM-100		;1
	dc.w		SCRN_TOP-120			;1
	dc.w		SCRN_BOTTOM-72			;1

;foreground objects
;$FF means no tile in that spot
;numbers > $80 are flipped - subtract $80 to get the tile number to use
flistcv::
	dc.b	$06,$07,$0E,$0F,$06,$05,$04,$07,$02,$07,$0C,$0D,$0E,$0F,$06,$05,$04,$03,$0E,$0D,$04,$05,$0A,$07,$0C,$05,$06,$0B,$0E,$01,$04,$03
	dc.b	$06,$0F,$0E,$07,$0C,$0D,$06,$0B,$0E,$0F,$04,$07,$06,$05,$04,$03,$0E,$09,$06,$03,$0C,$0B,$0E,$0D,$06,$0F,$04,$07,$02,$05,$0C,$0F
	dc.b	$06,$07,$04,$0D,$0E,$0F,$06,$07,$04,$05,$04,$0F,$0A,$07,$0C,$07,$02,$0F,$00,$07,$04,$07,$0E,$05,$0C,$07,$06,$0D,$0E,$03,$04,$0F
	dc.b	$06,$07,$0E,$05,$0C,$0F,$0A,$07,$06,$0D,$0E,$0F,$06,$05,$04,$07,$0E,$0D,$06,$0B,$04,$05,$0E,$0F,$04,$07,$06,$0D,$0E,$03,$06,$01
	dc.b	$0E,$05,$0C,$0F,$02,$07,$08,$0F,$00,$0F,$0A,$0D,$06,$0F,$0E,$05,$06,$07,$04,$0D,$0E,$03,$06,$09,$0E,$05,$06,$0F,$02,$07,$0E,$0D
	dc.b	$06,$01,$0E,$0B,$06,$0F,$04,$07,$0E,$05,$06,$0F,$0A,$0D,$0C,$07,$0E,$0F,$04,$05,$06,$0D,$0E,$07,$0C,$0F,$08,$07,$02,$0F,$00,$07
	dc.b	$0C,$0F,$0A,$05,$04,$03,$06,$0D,$0C,$07,$06,$0F,$04,$07,$0E,$0F,$06,$05,$06,$07,$0C,$0F,$06,$07,$0E,$0D,$04,$0F,$06,$07,$0E,$0F
	dc.b	$02,$05,$06,$07,$0E,$0F,$04,$07,$06,$03,$0E,$0D,$06,$0F,$04,$07,$0E,$05,$0A,$0F,$0C,$07,$0E,$0D,$06,$0F,$0E,$07,$0E,$0F,$04,$05
	dc.b	$06,$07,$0E,$0F,$0C,$07,$08,$0F,$06,$0D,$04,$07,$0E,$0F,$0C,$0B,$0E,$07,$06,$0F,$0E,$07,$04,$05,$0E,$0F,$0E,$07,$02,$0F,$06,$0D
	dc.b	$0E,$07,$06,$05,$0C,$03,$0E,$0D,$06,$09,$06,$0B,$0E,$0F,$06,$05,$0A,$03,$06,$01,$0E,$0D,$06,$07,$04,$0F,$00,$0F,$0C,$05,$06,$07
	dc.b	$04,$07,$02,$0D,$0E,$0F,$06,$07,$0C,$05,$06,$0F,$0E,$07,$04,$0B,$06,$0D,$06,$0F,$0C,$07,$0E,$05,$0A,$0F,$06,$07,$06,$0F,$08,$07
	dc.b	$04,$0D,$06,$0F,$06,$07,$0E,$05,$0C,$03,$06,$0F,$06,$07,$06,$0D,$02,$0F,$0E,$07,$04,$03,$06,$05,$0E,$09,$06,$0D,$0E,$0F,$0C,$07
	dc.b	$0E,$0F,$04,$05,$06,$07,$0E,$0D,$04,$0F,$0E,$05,$06,$07,$0A,$0F,$0E,$0D,$06,$0B,$0C,$05,$0E,$01,$06,$0D,$06,$07,$04,$0F,$02,$05
	dc.b	$0C,$07,$0E,$0F,$06,$03,$0E,$0D,$0C,$07,$0E,$0F,$04,$07,$02,$0F,$0C,$05,$06,$07,$0E,$0F,$04,$0D,$06,$0B,$0C,$07,$0E,$0F,$0A,$05
	dc.b	$06,$09,$0E,$0D,$0E,$07,$04,$0F,$02,$05,$00,$07,$0C,$0F,$06,$0D,$0E,$07,$04,$05,$06,$0F,$0E,$07,$0C,$0D,$06,$0F,$04,$03,$0E,$07
	dc.b	$06,$0F,$0C,$05,$0E,$07,$06,$0F,$04,$0D,$0A,$07,$0E,$0F,$06,$03,$04,$07,$0E,$0F,$06,$07,$04,$07,$06,$07,$06,$0F,$0E,$07,$06,$0F

;list of ground enemy/objects to create for each curbktile
glistcv::
	dc.b	$FF,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,FALLROCK,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,$FF,FALLROCK			;16 objects per line
	dc.b	$FF,$FF,$FF,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,FALLROCK,$FF,$FF,FALLROCK
	dc.b	$FF,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,$FF,SLUG,$FF,DINO,$FF,SLUG
	dc.b	$FF,FALLROCK,$FF,$FF,SLUG,FALLROCK,$FF,$FF,SLUG,FALLROCK,$FF,$FF,FALLROCK,SLUG,DINO,$FF
	dc.b	SLUG,FALLROCK,$FF,DINO,$FF,SLUG,$FF,$FF,FALLROCK,$FF,$FF,SLUG,DINO,FALLROCK,$FF,SLUG
	dc.b	$FF,SLUG,$FF,$FF,$FF,FALLROCK,FALLROCK,$FF,$FF,SLUG,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF
	dc.b	$FF,SLUG,$FF,DINO,$FF,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,DINO,$FF,FALLROCK,$FF,$FF
	dc.b	$FF,$FF,SLUG,$FF,$FF,FALLROCK,$FF,$FF,$FF,FALLROCK,$FF,$FF,SLUG,$FF,$FF,FALLROCK
	dc.b	STATION,$FF,DINO,$FF,$FF,$FF,FALLROCK,DINO,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,DINO,$FF
	dc.b	$FF,$FF,$FF,FALLROCK,$FF,$FF,DINO,$FF,$FF,FALLROCK,FALLROCK,$FF,$FF,$FF,FALLROCK,$FF
	dc.b	$FF,FALLROCK,$FF,$FF,$FF,$FF,FALLROCK,$FF,$FF,$FF,FALLROCK,$FF,DINO,$FF,$FF,$FF
	dc.b	$FF,SLUG,$FF,SLUG,FALLROCK,SLUG,$FF,$FF,FALLROCK,$FF,$FF,SLUG,DINO,SLUG,$FF,SLUG
	dc.b	$FF,FALLROCK,$FF,$FF,SLUG,$FF,$FF,$FF,FALLROCK,SLUG,$FF,$FF,FALLROCK,$FF,$FF,$FF
	dc.b	FALLROCK,SLUG,$FF,$FF,FALLROCK,$FF,$FF,DINO,SLUG,$FF,FALLROCK,$FF,$FF,FALLROCK,$FF,$FF
	dc.b	$FF,FALLROCK,FALLROCK,$FF,DINO,FALLROCK,$FF,$FF,SLUG,FALLROCK,$FF,$FF,FALLROCK,$FF,$FF,$FF
	dc.b	SLUG,DINO,$FF,FALLROCK,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;256

;enemies for cave level			32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;bat
;small spider
;big spider
;small dino
elistcv::
	dc.b	      99,      99,      99,      99,      99, GLOWBUG,      99, DINO_SM,      99,      99,      99, GLOWBUG,      99, DINO_SM,      99,      99
	dc.b	 DINO_SM,      99,      99,      99, GLOWBUG,      99,      99, DINO_SM,      99, DINO_SM,      99,      99, GLOWBUG, GLOWBUG,      99,      99
	dc.b	      99, DINO_SM,      99,      99,      99,      99, GLOWBUG,      99,      99,      99, DINO_SM,      99, GLOWBUG,      99, GLOWBUG,      99
	dc.b	 GLOWBUG,      99, GLOWBUG,      99,      99,      99, GLOWBUG,      99,      99,      99,      99,     BAT, GLOWBUG,      99, DINO_SM,SPIDERBG
	dc.b	      99, GLOWBUG,      99,      99,      99,      99,      99, GLOWBUG,SPIDERBG,      99, DINO_SM,      99,      99, GLOWBUG,      99, DINO_SM
	dc.b	SPIDERBG,      99,      99, GLOWBUG,      99,      99, DINO_SM,      99,      99, GLOWBUG,      99,      99,SPIDERBG, DINO_SM,      99,      99
	dc.b	 GLOWBUG,      99,      99,      99, GLOWBUG,      99,      99, DINO_SM,     BAT,      99, GLOWBUG,      99,      99, DINO_SM,      99, GLOWBUG
	dc.b	      99, DINO_SM,      99,      99, GLOWBUG,      99,SPIDERBG,      99,      99, DINO_SM,      99,      99,      99,      99,SPIDERSM, GLOWBUG
	dc.b	 DINO_SM,      99,      99,      99,      99,SPIDERBG,      99, DINO_SM,      99,      99,      99,SPIDERSM, GLOWBUG,      99,      99,SPIDERBG
	dc.b	      99,SPIDERBG,      99,      99, GLOWBUG,      99,SPIDERSM,      99,      99, GLOWBUG,      99,      99,SPIDERBG,      99,      99, DINO_SM
	dc.b	      99,      99,SPIDERSM, GLOWBUG,      99, DINO_SM,      99,SPIDERBG,SPIDERBG,      99, GLOWBUG,      99,      99,      99,SPIDERSM, GLOWBUG
	dc.b	      99,      99,      99, GLOWBUG,SPIDERBG,      99,      99,      99,      99,SPIDERSM,      99,      99, DINO_SM,      99,      99,SPIDERBG
	dc.b	      99,      99,SPIDERBG,      99,      99, GLOWBUG,      99,      99,SPIDERBG,      99,      99,      99,SPIDERBG,      99,SPIDERBG,      99
	dc.b	     BAT,      99,SPIDERBG,      99,      99, DINO_SM,SPIDERBG,      99,      99,      99,SPIDERBG,      99,      99,      99,SPIDERBG,      99
	dc.b	      99,SPIDERBG,SPIDERBG,      99,      99,      99,SPIDERBG,      99, GLOWBUG, DINO_SM,      99,      99,SPIDERBG,      99,      99,      99
	dc.b	      99,      99,      99, GLOWBUG,SPIDERBG,      99,      99, GLOWBUG,      99,      99,SPIDERBG,      99,      99, DINO_SM,SPIDERBG,      99
	dc.b	      99,SPIDERBG, GLOWBUG,     BAT,      99,      99,      99,SPIDERBG,      99,      99, GLOWBUG,      99,      99,SPIDERBG,      99,      99
	dc.b	 DINO_SM,      99,      99,SPIDERBG,      99, GLOWBUG,      99,      99,      99,SPIDERBG,      99,      99, GLOWBUG,      99,      99,SPIDERBG
	dc.b	      99,      99, GLOWBUG,      99,      99,SPIDERBG,      99,      99, GLOWBUG, DINO_SM,      99,SPIDERBG,      99,     BAT,      99,      99
	dc.b	 GLOWBUG,      99,SPIDERBG,      99,      99,      99,SPIDERBG,      99,      99,      99,      99,      99,SPIDERBG, DINO_SM,      99, DINO_SM
	dc.b	      99,      99,      99,      99,      99,      99, GLOWBUG,SPIDERSM,      99,      99,      99,SPIDERSM,      99,SPIDERSM,      99,      99
	dc.b	 DINO_SM,      99,      99,      99,SPIDERSM,SPIDERBG,      99,     BAT,SPIDERSM,      99,      99,      99, GLOWBUG,      99,      99,      99
	dc.b	SPIDERSM,      99,      99,      99,      99,      99,      99, GLOWBUG,      99,      99, DINO_SM, DINO_SM,      99,      99,SPIDERBG,      99
	dc.b	      99,      99,      99,      99,SPIDERSM,      99,      99,      99,      99,      99,      99, DINO_SM,      99,      99,     BAT,      99
	dc.b	     BAT,      99,      99,      99,      99,SPIDERBG,      99,SPIDERSM,      99,      99,      99, DINO_SM,      99,      99,     BAT,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99,      99, DINO_SM,      99,SPIDERBG,      99,SPIDERSM,      99, DINO_SM
	dc.b	      99,      99,      99,      99, GLOWBUG,      99,      99,      99,      99,      99,      99,      99,      99,      99, DINO_SM,      99
	dc.b	SPIDERSM,      99,      99,      99,SPIDERBG,      99,      99, DINO_SM,      99,      99,SPIDERSM,      99,      99,      99,      99, GLOWBUG
	dc.b	 DINO_SM,      99,      99,      99,      99,      99,SPIDERSM,      99,      99,      99,      99,      99,      99,      99,SPIDERBG,      99
	dc.b	 GLOWBUG,      99,      99,SPIDERSM,      99, DINO_SM, GLOWBUG,      99,      99,      99,      99,      99,      99, GLOWBUG,      99,     BAT
	dc.b	      99,      99, DINO_SM,      99,      99,      99,     BAT,      99,      99, DINO_SM,      99,      99,     BAT, DINO_SM,      99,      99
	dc.b	SPIDERBG,      99,      99,      99,      99,      99,      99, DINO_SM, DINO_SM,      99,      99,     BAT,      99, DINO_SM, DINO_SM, DINO_SM
	dc.b	      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99,     BAT,      99,      99,      99, DINO_SM,SPIDERBG
	dc.b	      99,      99,      99, DINO_SM,      99,      99, DINO_SM, GLOWBUG,      99,      99,      99,      99,     BAT, DINO_SM,      99,      99
	dc.b	      99,      99,      99,      99,SPIDERBG, DINO_SM,      99,      99, GLOWBUG,      99,      99,      99,      99,     BAT,      99,      99
	dc.b	      99,      99,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM, GLOWBUG,      99,      99,SPIDERBG,      99,     BAT
	dc.b	      99, DINO_SM,      99,      99,      99,      99,      99,      99,      99, DINO_SM,     BAT,      99,      99,     BAT,      99, DINO_SM
	dc.b	      99,     BAT,      99,      99,      99,     BAT,      99,      99,SPIDERBG,      99, DINO_SM,      99, GLOWBUG,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,     BAT,     BAT,     BAT,     BAT
	dc.b	      99,     BAT,      99,     BAT,      99,     BAT,     BAT,SPIDERBG,     BAT,      99,     BAT,      99,      99,      99,     BAT,     BAT
	dc.b	      99,     BAT,      99,     BAT,      99, DINO_SM,     BAT,      99, GLOWBUG,     BAT,     BAT,      99,     BAT,     BAT,      99, DINO_SM
	dc.b	     BAT,SPIDERSM,     BAT,      99,      99,SPIDERBG,      99,      99,      99,      99,SPIDERSM,SPIDERBG,      99, DINO_SM,      99,      99
	dc.b	SPIDERBG,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99,SPIDERSM,      99,      99,      99,      99
	dc.b	      99,SPIDERBG,      99,      99,      99, DINO_SM,      99,      99,SPIDERBG, GLOWBUG, DINO_SM,      99,      99,      99, DINO_SM,      99
	dc.b	      99,      99,      99,      99,SPIDERSM,      99,     BAT,      99,SPIDERBG,      99,      99,      99, DINO_SM,      99,      99,      99
	dc.b	      99,      99,      99,      99, DINO_SM,      99,      99,SPIDERBG, DINO_SM,      99,      99, GLOWBUG,      99,     BAT,      99,SPIDERBG
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99, DINO_SM,      99,      99, DINO_SM,      99,      99,      99,SPIDERSM
	dc.b	      99,      99, DINO_SM,      99,      99,SPIDERBG,      99, DINO_SM,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99
	dc.b	      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99
	dc.b	      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99
	dc.b	      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99
	dc.b	      99, DINO_SM,      99, DINO_SM,      99, DINO_SM,      99, DINO_SM,      99, DINO_SM,      99,      99,      99, DINO_SM,      99,      99
	dc.b	 DINO_SM,      99, GLOWBUG,      99, GLOWBUG,      99,      99, DINO_SM,      99,      99,     BAT, GLOWBUG,SPIDERBG,      99, DINO_SM,      99
	dc.b	     BAT, DINO_SM,      99,      99,      99, DINO_SM,     BAT, DINO_SM,      99,      99,     BAT,      99, DINO_SM,      99,     BAT,      99
	dc.b	SPIDERBG,      99,     BAT,SPIDERSM,      99, DINO_SM,      99,      99, GLOWBUG,     BAT,      99,     BAT, DINO_SM, GLOWBUG,      99,     BAT
	dc.b	      99,     BAT, DINO_SM,      99,     BAT, GLOWBUG,     BAT, DINO_SM,SPIDERBG,      99,     BAT,      99,     BAT,     BAT,     BAT, GLOWBUG
	dc.b	      99,     BAT, GLOWBUG, DINO_SM,     BAT,      99,     BAT,      99, DINO_SM,      99,      99,     BAT,      99, DINO_SM,     BAT, GLOWBUG
	dc.b	 DINO_SM,SPIDERBG,     BAT,      99,     BAT, DINO_SM,      99,     BAT,      99, DINO_SM,     BAT,      99,      99, DINO_SM,      99,     BAT
	dc.b	 DINO_SM,      99,     BAT,      99, DINO_SM,     BAT,      99,     BAT, DINO_SM,      99,     BAT,      99,     BAT, DINO_SM,     BAT,     BAT
	dc.b	SPIDERBG,     BAT,      99, DINO_SM,     BAT,      99, DINO_SM,     BAT,SPIDERBG,     BAT, DINO_SM,      99,     BAT,      99,SPIDERBG, DINO_SM
	dc.b	 GLOWBUG,      99,SPIDERBG,     BAT,      99,      99,     BAT,SPIDERBG,     BAT,      99, DINO_SM,      99,SPIDERBG,     BAT,      99, DINO_SM
	dc.b	     BAT,SPIDERBG,     BAT,      99, DINO_SM,SPIDERBG,      99,      99,      99,SPIDERBG,      99,      99,      99,SPIDERBG,      99,      99
	dc.b	      99,SPIDERBG, GLOWBUG,      99,SPIDERBG,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99

;*****************************************************************************************************
tlistcty::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$02,$0A,$10,$02,$0A,$0B,$06,$0F,$03,$0C,$03,$07,$01,$10,$0D,$08,$09,$02,$0A,$0B,$07,$08,$0E,$06,$05,$0C,$0B,$07,$01,$0D,$08
	dc.b	$0E,$04,$0F,$0D,$0E,$0F,$0D,$0E,$0F,$10,$02,$10,$03,$0F,$02,$0A,$02,$0B,$06,$0F,$02,$10,$03,$05,$06,$0F,$0D,$11,$00,$03,$05,$07
	dc.b	$09,$0D,$0E,$06,$05,$06,$05,$0F,$03,$04,$0F,$02,$10,$0B,$06,$0F,$03,$0C,$10,$0A,$03,$0F,$02,$0A,$10,$03,$04,$06,$07,$09,$0D,$09
	dc.b	$03,$05,$06,$05,$04,$0C,$0B,$06,$05,$07,$08,$0E,$07,$08,$09,$0B,$04,$07,$0E,$0F,$03,$06,$07,$0E,$0F,$03,$0F,$03,$0C,$0A,$10,$02
	dc.b	$03,$04,$07,$01,$03,$05,$0F,$0A,$0B,$04,$0F,$0B,$0F,$10,$02,$03,$0C,$0B,$05,$04,$07,$08,$09,$03,$07,$09,$10,$03,$0C,$0B,$0C,$0B
	dc.b	$07,$01,$0B,$05,$0C,$0A,$03,$04,$0F,$03,$07,$01,$0D,$09,$0A,$0D,$01,$03,$0C,$0A,$02,$0D,$08,$11,$00,$02,$03,$0F,$0A,$03,$0C,$0D
	dc.b	$01,$0A,$0D,$11,$00,$0B,$05,$0C,$03,$0F,$02,$0D,$09,$0A,$02,$10,$03,$05,$04,$07,$08,$01,$0A,$0B,$05,$04,$0F,$02,$0A,$0D,$0E,$0C
	dc.b	$0B,$04,$05,$07,$0E,$0F,$03,$04,$06,$0F,$10,$0D,$09,$0A,$02,$0D,$08,$11,$00,$10,$03,$04,$0C,$0B,$05,$06,$0C,$0A,$10,$0A,$03,$0F
;odd it gets loaded here       |***|
	dc.b	$10,$02,$0B,$04,$05,$06,$07,$08,$11,$13,$14,$15,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12

;info for foreground objects
frinfcty::
;data
	dc.l		bldg00,bldg00,bldg00,bldg01,bldg01,bldg01,bldg01,bldg02,bldg02,bldg02,bldg03,bldg03,bldg03,bldg00,bldg01,bldg02
;height
	dc.w		112,112,112,128,128,128,128,128,128,128,88,88,88,112,128,128
;width
	dc.w		80,80,80,160,160,160,160,128,128,128,112,112,112,80,160,128
;dwidth, iwidth
	dc.w		20,20,20,40,40,40,40,32,32,32,28,28,28,20,40,32
;ypos
	dc.w		SCRN_BOTTOM-224		;bldg 0
	dc.w		SCRN_BOTTOM-166		;bldg 0
	dc.w		SCRN_BOTTOM-112		;bldg 0
	dc.w		SCRN_BOTTOM-256		;bldg 1
	dc.w		SCRN_BOTTOM-200		;bldg 1
	dc.w		SCRN_BOTTOM-140		;bldg 1
	dc.w		SCRN_BOTTOM-80			;bldg 1
	dc.w		SCRN_BOTTOM-256		;bldg 2
	dc.w		SCRN_BOTTOM-180		;bldg 2
	dc.w		SCRN_BOTTOM-100		;bldg 2
	dc.w		SCRN_BOTTOM-192		;bldg 3
	dc.w		SCRN_BOTTOM-130		;bldg 3
	dc.w		SCRN_BOTTOM-68			;bldg 3
	dc.w		SCRN_BOTTOM-70			;bldg 0
	dc.w		SCRN_BOTTOM-110		;bldg 1
	dc.w		SCRN_BOTTOM-76			;bldg 2

;foreground objects
;$FF means no tile in that spot
;numbers > $80 are flipped - subtract $80 to get the tile number to use
flistcty::
	dc.b	$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$0B,$FF,$FF,$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$0D,$FF,$FF,$FF,$FF,$FF,$05,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$0E,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$07,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$0A,$FF,$FF,$FF,$FF,$FF,$FF,$06,$FF,$FF,$FF,$FF,$FF,$FF,$07,$FF,$FF,$FF,$FF,$FF,$02,$FF,$FF
	dc.b	$FF,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$08,$FF,$FF,$FF,$0B,$FF,$FF,$FF,$06,$FF
	dc.b	$FF,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$0A,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$05,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$FF,$FF,$07,$FF,$FF,$0E,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$FF,$0B,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$0D,$FF,$FF,$FF,$FF,$08,$FF,$FF,$FF,$06,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$07,$FF,$FF,$FF,$FF,$0A,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$0B,$FF,$FF,$FF,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$06,$FF,$FF,$FF
	dc.b	$02,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$0E,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$04,$FF,$FF,$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$0A,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$01,$FF,$FF,$FF,$FF,$FF,$08,$FF,$FF,$FF,$FF,$FF,$05,$FF,$FF,$FF,$FF,$FF,$00,$FF
	dc.b	$0D,$FF,$FF,$FF,$FF,$FF,$FF,$0C,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$07,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$02,$FF,$FF,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$09,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$0B,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$02,$FF,$FF,$FF,$FF,$08,$FF,$FF,$FF,$FF,$06,$FF,$FF,$FF,$0E,$FF,$FF,$FF,$FF
	dc.b	$0C,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

;list of ground enemy/objects to create for each curbktile
glistcty::
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,MINGBOT,$FF,$FF,$FF,$FF,$FF,$FF			;16 objects per line
	dc.b	$FF,$FF,$FF,$FF,$FF,MINGBOT,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,MINGBOT,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,MINGBOT,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,MINGBOT,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	ELEC,TOWER,$FF,$FF,TOWER,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	STATION,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,MINGBOT,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,MINGBOT,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,MINGBOT,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;256

;enemies for city level			32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;fish taxi
;snake
elistcty::
	dc.b	      99,      99,  FISHTX,      99, EYELGBL,      99,      99,      99,      99,  FISHTX,      99,      99,  FISHTX,      99, EYELGBL,      99
	dc.b	      99,  FISHTX, EYESMBL,      99,      99,      99,  FISHTX,      99,      99,      99,  FISHTX,      99,      99,  FISHTX,      99,      99
	dc.b	      99, EYELGBL,  FISHTX,      99,      99,   SNAKE,      99,      99, EYESMBL, EYELGBL,      99,      99,      99,      99,   SNAKE, EYESMGR
	dc.b	  FISHTX, EYELGGR,      99,      99,      99,      99, EYESMBL,      99,  FISHTX,      99,  FISHTX, EYELGBL,      99,      99,      99,      99
	dc.b	      99,      99,      99,   SNAKE,      99,      99,      99,  FISHTX,   SNAKE,      99,      99,      99,  FISHTX, EYESMBL,      99,      99
	dc.b	      99,      99, EYELGBL,  FISHTX,      99,      99,      99,  FISHTX,   SNAKE,      99,  FISHTX,      99,      99,      99,      99,      99
	dc.b	  FISHTX,      99, EYELGGR,      99,      99,  FISHTX,  FISHTX, EYELGBL,      99,      99,      99,      99,   ROBOT,      99,      99,      99
	dc.b	      99,      99, EYESMBL,   SNAKE,      99,      99,      99, EYELGBL,  FISHTX,      99,      99,      99, EYESMGR,      99,   SNAKE,      99
	dc.b	  FISHTX,      99, EYESMBL,      99,      99,      99,  FISHTX,   SNAKE,      99,      99,  FISHTX,      99,      99,      99,      99, EYELGGR
	dc.b	      99,      99,      99,      99,  FISHTX,      99,      99,      99,      99,  FISHTX,      99,      99, EYESMGR,      99,   SNAKE,  FISHTX
	dc.b	      99, EYELGBL,      99,      99,      99, EYELGBL,      99, EYESMBL,      99, EYELGGR, EYELGBL, EYESMBL,      99,      99, EYESMBL, EYELGBL
	dc.b	 EYESMBL, EYELGGR,      99,      99, EYESMBL,      99,      99, EYELGGR,      99,      99, EYELGBL,  FISHTX,      99, EYELGBL,      99, EYELGGR
	dc.b	      99, EYELGBL,      99,      99, EYESMBL,      99,      99, EYESMBL,      99, EYELGGR,      99, EYESMBL,      99,      99, EYESMBL,      99
	dc.b	      99,      99,      99, EYELGBL,      99,  FISHTX,      99, EYELGGR,      99,      99, EYELGBL,      99, EYESMGR,      99,      99, EYELGGR
	dc.b	      99, EYELGBL,      99,      99,      99, EYELGBL,      99, EYESMBL,      99, EYELGGR,      99, EYESMBL,      99,      99, EYESMBL, EYELGBL
	dc.b	      99, EYELGGR,      99,      99, EYESMBL,      99,      99, EYELGGR,  FISHTX,      99, EYELGBL,      99,      99, EYELGBL,      99, EYELGGR
	dc.b	      99, EYELGBL,      99,      99, EYESMBL,      99,      99, EYESMBL,      99, EYELGGR, EYELGBL, EYESMBL,      99,      99, EYESMBL,      99
	dc.b	      99, EYELGBL,      99,      99,      99,      99,   SNAKE,      99,      99,      99,      99,  FISHTX,      99,  FISHTX,      99, EYESMBL
	dc.b	   SNAKE,      99,      99,      99, EYESMBL,      99,      99,   SNAKE,      99,   SNAKE,      99,      99,   SNAKE, EYELGGR,   SNAKE,      99
	dc.b	      99,      99,      99,      99,   SNAKE,      99,      99,      99,      99,  FISHTX, EYESMBL,      99,      99,      99, EYESMGR,      99
	dc.b	      99,  FISHTX,      99,      99, EYELGGR,      99,      99,      99,      99,      99,      99,   SNAKE,      99,  FISHTX,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99, EYELGBL,      99,      99,      99,      99,      99,      99,   ROBOT,      99, EYELGGR
	dc.b	  FISHTX,      99,      99,  FISHTX,      99,      99,      99,      99,  FISHTX,      99,      99,   SNAKE,   SNAKE,  FISHTX,      99,      99
	dc.b	      99,      99,  FISHTX,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99, EYESMBL,      99
	dc.b	   SNAKE,      99,      99,  FISHTX,      99,      99,      99,      99,  FISHTX,      99,      99,  FISHTX,      99, EYELGBL,      99,      99
	dc.b	      99, EYELGBL,      99, EYELGGR, EYESMBL,      99,      99, EYESMBL,      99, EYELGGR, EYELGBL,      99,      99,      99, EYESMBL, EYELGBL
	dc.b	      99, EYELGGR,      99,      99, EYESMBL,      99,      99, EYELGGR,      99,      99, EYELGBL,      99, EYESMGR, EYELGBL,      99, EYELGGR
	dc.b	      99,  FISHTX,      99,  FISHTX,      99, EYESMBL,      99,      99,      99,      99,      99,  FISHTX,      99,      99,      99,      99
	dc.b	   ROBOT,      99,      99, EYELGGR,      99,      99,      99,      99,      99,      99,  FISHTX,   SNAKE,      99,      99,      99,      99
	dc.b	   SNAKE,      99,      99,  FISHTX,      99,      99,      99,      99,      99,      99,  FISHTX,      99,   SNAKE, EYELGBL,      99,      99
	dc.b	      99,      99,      99,      99,   SNAKE,      99, EYESMBL,  FISHTX,      99, EYESMGR,      99,      99,   SNAKE,      99,      99,      99
	dc.b	      99,  FISHTX,   SNAKE,      99, EYELGGR,      99,      99, EYESMBL,      99,      99,      99,      99,      99,   SNAKE,      99,      99
	dc.b	   SNAKE,      99,      99, EYELGBL,      99,      99,      99,   ROBOT,      99,   SNAKE,      99,   SNAKE,      99,  FISHTX,      99,      99
	dc.b	 EYESMBL,   SNAKE,      99,      99,  FISHTX, EYELGGR,      99,      99,      99,      99,      99,      99,  FISHTX,  FISHTX,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99, EYELGBL,      99,  FISHTX,      99,      99,      99,      99,      99,      99,      99
	dc.b	      99,      99,      99,      99,      99,      99,      99,      99,      99,  FISHTX,      99,      99, EYESMGR,      99,   SNAKE,  FISHTX
	dc.b	      99,  FISHTX,      99,      99,   SNAKE,      99,      99,      99,  FISHTX,   SNAKE,      99,      99,      99,      99,      99,  FISHTX
	dc.b	      99,      99,      99,      99,      99,      99, EYESMBL,  FISHTX,      99,      99, EYELGGR,      99,      99,      99,      99,      99
	dc.b	      99,      99,  FISHTX,      99,      99,   SNAKE,      99,  FISHTX,      99,      99,  FISHTX,      99,      99,      99,      99,      99
	dc.b	      99,      99, EYELGBL,      99,      99, EYESMGR,   ROBOT,      99,      99,  FISHTX,      99,      99, EYESMGR,      99,      99,  FISHTX
	dc.b	   SNAKE,  FISHTX,      99, EYESMGR,      99,      99,      99,      99, EYELGGR,      99,   SNAKE,      99, EYESMBL,      99,      99,      99
	dc.b	      99,  FISHTX,   SNAKE,      99,      99,  FISHTX,      99,      99,   SNAKE, EYELGBL,      99,   SNAKE,      99,   SNAKE,      99,      99
	dc.b	   SNAKE,  FISHTX, EYESMBL,      99,   SNAKE,      99,      99,      99,   SNAKE,   SNAKE,      99,   SNAKE,      99,  FISHTX,   SNAKE,      99
	dc.b	      99,  FISHTX,      99, EYESMGR,      99, EYELGGR, EYESMBL,      99,   SNAKE,      99,   SNAKE,      99,   SNAKE,  FISHTX,      99,   SNAKE
	dc.b	      99,   SNAKE,   SNAKE, EYELGBL,      99,      99,      99, EYESMBL,      99,  FISHTX,      99,      99,   SNAKE,  FISHTX,      99,      99
	dc.b	  FISHTX,      99,  FISHTX, EYELGGR,      99,      99,   SNAKE,      99,      99,   SNAKE,  FISHTX,      99,      99,      99,  FISHTX, EYELGBL
	dc.b	      99,      99,   SNAKE,      99,      99,  FISHTX,   SNAKE,      99,  FISHTX,      99, EYESMGR,      99, EYESMBL,      99,  FISHTX,   SNAKE
	dc.b	      99,      99,   SNAKE,      99, EYELGGR,      99,   SNAKE,   ROBOT,      99,      99,      99,      99,      99,   SNAKE,      99,   SNAKE
	dc.b	      99,  FISHTX,      99,      99,   SNAKE,      99,  FISHTX,      99,      99,      99,   SNAKE,      99,  FISHTX,      99, EYELGBL,      99
	dc.b	   SNAKE,      99,  FISHTX,      99,      99, EYESMBL,   SNAKE,  FISHTX,      99,      99,      99,   SNAKE,      99, EYELGGR,      99,      99
	dc.b	      99,      99,  FISHTX, EYESMGR,      99,      99,      99,      99,  FISHTX, EYESMBL,      99,   SNAKE,  FISHTX,      99,   SNAKE,      99
	dc.b	      99,      99,   SNAKE,      99,   SNAKE,   SNAKE,      99, EYELGGR,      99,      99,  FISHTX,      99, EYELGBL,      99, EYESMBL,      99
	dc.b	      99,   SNAKE,  FISHTX,   SNAKE,      99,   SNAKE,      99,   SNAKE, EYESMGR,  FISHTX,      99,      99,      99, EYESMBL,      99,      99
	dc.b	   SNAKE,  FISHTX,      99,      99,   SNAKE,      99,      99,  FISHTX,      99,      99,      99,  FISHTX,      99,   SNAKE, EYELGGR,   SNAKE
	dc.b	      99,      99, EYELGBL,      99,      99,      99,      99,   SNAKE, EYESMBL,      99,      99,   SNAKE,      99,  FISHTX,      99,      99
	dc.b	      99,      99,   SNAKE,      99,  FISHTX,  FISHTX,      99,      99,      99,   SNAKE,      99,   SNAKE,      99, EYELGGR,      99,   SNAKE
	dc.b	      99,      99, EYESMBL,  FISHTX,   ROBOT,      99,      99,      99, EYESMGR, EYELGBL,      99,      99,      99,   SNAKE,      99, EYELGGR
	dc.b	      99,   SNAKE,   SNAKE,      99,      99, EYESMBL,      99,   SNAKE,      99,   SNAKE,      99,      99,      99, EYELGBL,      99, EYELGGR
	dc.b	   SNAKE,      99,   SNAKE, EYESMBL, EYESMGR,      99,      99,   SNAKE,      99,      99,      99,      99,      99,   SNAKE, EYESMGR,      99
	dc.b	   SNAKE,      99, EYELGGR,  FISHTX,      99,      99, EYESMBL,      99,      99,   SNAKE,      99,   SNAKE,      99,   SNAKE,      99,      99
	dc.b	  FISHTX,      99,      99,   SNAKE,      99,      99, EYESMGR, EYELGBL,      99,   SNAKE,      99, EYELGGR,   SNAKE,   SNAKE,      99,   SNAKE
	dc.b	      99,   SNAKE,      99,      99,  FISHTX,      99, EYESMBL,   ROBOT,      99,      99,      99,      99, EYESMGR,  FISHTX,      99,   SNAKE
	dc.b	      99,      99,      99,      99,  FISHTX,      99,   SNAKE,      99,   SNAKE,      99, EYELGGR,   SNAKE,      99,      99,      99, EYESMBL
	dc.b	      99,   SNAKE,   SNAKE,      99, EYESMGR, EYELGBL,      99,      99,   SNAKE, EYELGBL,      99,      99,      99,      99,   SNAKE,      99
	dc.b	      99,   SNAKE,  FISHTX,      99,      99,      99,   SNAKE,  FISHTX,      99,      99,      99, EYELGBL,      99,      99,      99,      99
	dc.b	  FISHTX,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99,      99



;*****************************************************************************************************
tlistsp0::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$04,$01,$02,$0C,$06,$09,$0B,$00,$01,$08,$02,$0C,$00,$04,$01,$09,$0C,$06,$08,$09,$03,$05,$0A,$06,$08,$02,$0C,$0A,$03,$01,$09
	dc.b	$00,$01,$08,$02,$03,$04,$01,$02,$0D,$06,$02,$0C,$0A,$0C,$0A,$0C,$06,$07,$02,$00,$05,$0D,$0A,$06,$02,$0C,$00,$05,$0D,$0A,$0D,$0C
	dc.b	$0B,$0C,$00,$04,$01,$02,$06,$09,$0D,$0C,$06,$08,$09,$00,$05,$0D,$03,$01,$07,$08,$07,$08,$02,$0C,$00,$05,$0D,$0C,$03,$04,$01,$09
	dc.b	$00,$04,$01,$09,$03,$04,$05,$0A,$03,$01,$02,$06,$07,$08,$07,$09,$03,$01,$02,$0B,$00,$04,$05,$0B,$0D,$0A,$06,$09,$0B,$0C,$06,$07
	dc.b	$09,$03,$01,$08,$02,$0B,$0D,$03,$01,$07,$02,$0C,$06,$02,$00,$05,$0A,$00,$05,$0B,$0D,$06,$09,$0C,$03,$01,$08,$02,$0D,$03,$04,$05
	dc.b	$06,$09,$0B,$06,$09,$0C,$00,$04,$01,$02,$06,$02,$0C,$0A,$0C,$00,$01,$09,$00,$01,$08,$02,$06,$08,$07,$08,$02,$0B,$0D,$06,$02,$03
	dc.b	$05,$06,$09,$0A,$0B,$0D,$0C,$03,$04,$01,$07,$02,$00,$05,$0B,$03,$05,$0B,$0D,$0C,$06,$02,$06,$09,$0A,$03,$04,$05,$06,$08,$07,$02
	dc.b	$0C,$0B,$03,$01,$07,$09,$0C,$0A,$03,$04,$01,$09,$0B,$0A,$06,$07,$02,$0A,$00,$05,$0A,$00,$05,$0C,$0A,$0D,$0C,$0A,$06,$09,$0C,$00
;end of space level
	dc.b	$04,$01,$02,$00,$04,$01,$07,$08,$07,$02,$0D,$0B,$00,$01,$07,$02,$0D,$00,$04,$01,$02,$0D,$0A,$0C,$0D,$00,$05,$0D,$00,$05,$0A,$03
	dc.b	$05,$0B,$03,$05,$0A,$0C,$0A,$0C,$0B,$0A,$03,$04,$01,$08,$09,$0B,$00,$01,$09,$06,$07,$09,$0C,$03,$01,$08,$07,$09,$0B,$0A,$06,$07
	dc.b	$08,$02,$0C,$0D,$03,$04,$05,$0A,$06,$09,$0B,$0A,$06,$09,$0C,$03,$01,$07,$09,$03,$01,$02,$0A,$0B,$0D,$0A,$0D,$0A,$06,$07,$09,$06

;enemies for space level 0		32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;big rock
;big crystal
;big star
;burple
;bubble
;cube
;sphere
elistsp0::
	dc.b	 BIGROCK,      99,      99, BIGCRYS,      99,      99, BIGROCK,      99, BIGROCK,      99,   BSTAR,      99, BIGROCK, MEDROCK,      99, BIGROCK
	dc.b	   BSTAR, BIGROCK,      99,      99, BIGROCK,      99, BUBBLEB, BIGCRYS,   BSTAR,      99,  SPHERE, BIGROCK, MEDROCK,   BSTAR, BIGROCK, BIGCRYS
	dc.b	      99, MEDROCK, BIGROCK,      99, MEDROCK, BIGROCK,    CUBE,      99, BURPLEB, BIGROCK,      99,   BSTAR,      99, BIGCRYS, BIGROCK,      99
	dc.b	      99, BIGROCK,   BSTAR, BIGROCK, BUBBLEB, MEDROCK,   BSTAR, MEDROCK, BIGCRYS,      99,  SPHERE,      99, BIGROCK, BIGROCK,      99, BIGROCK
	dc.b	 BIGROCK, BIGROCK,      99,   BSTAR,   BSTAR,      99, BIGCRYS, BIGCRYS, BIGROCK, BIGROCK,   BSTAR,    CUBE, BIGROCK,      99, BIGROCK,      99
	dc.b	 MEDROCK, MEDROCK, BIGROCK,      99,   BSTAR,      99, BIGROCK,   BSTAR, BIGROCK, BIGROCK,      99, BIGROCK,      99,      99, BIGCRYS, BIGROCK
	dc.b	 BIGROCK,      99,      99, BIGCRYS,  SPHERE, BIGROCK,   BSTAR, BIGROCK, MEDROCK, BIGROCK, BIGCRYS, MEDROCK,      99,      99, BIGROCK, BUBBLEB
	dc.b	   BSTAR, BIGROCK,      99,      99, BIGROCK, BIGROCK,      99,      99, BURPLEB, BIGROCK,   BSTAR, BIGROCK,    CUBE,      99, BIGROCK, BIGROCK
	dc.b	      99, MEDROCK, BIGROCK, MEDROCK,   BSTAR,      99,      99, BIGROCK, BIGROCK, BIGROCK,      99, BIGROCK, BIGROCK,      99, BIGCRYS,      99
	dc.b	 BIGROCK,   BSTAR, BIGROCK,      99,   BSTAR,      99, BIGROCK,      99, BIGROCK, BIGCRYS,  SPHERE, BURPLES, BIGROCK, BUBBLEB, BURPLES, MEDROCK
	dc.b	 BURPLES, BIGROCK, BIGROCK, BURPLES,      99,   BSTAR, BIGROCK, BIGROCK, BIGROCK, BIGCRYS, BURPLES, BIGCRYS, MEDROCK,   BSTAR, BIGROCK,   BSTAR
	dc.b	 BIGROCK, BIGROCK,    CUBE,      99,      99, MEDROCK, BURPLEB, BIGROCK, BURPLES, BIGROCK, BURPLES, BIGROCK, MEDROCK, BIGROCK, BURPLES,   BSTAR
	dc.b	 BIGROCK,   BSTAR, BIGROCK,      99, BIGROCK, BURPLEB, BIGCRYS, BIGROCK,   BSTAR, BIGROCK, BUBBLEB,   BSTAR,      99, BURPLES,  SPHERE, BURPLES
	dc.b	   BSTAR, MEDROCK, BIGROCK, BURPLES, BURPLES, BIGROCK,      99, BIGROCK, BIGROCK,      99, BIGCRYS,      99, BIGCRYS, BIGROCK,      99, BIGROCK
	dc.b	      99,      99,   BSTAR,      99, BIGROCK,      99,      99,      99, BIGROCK,   BSTAR,      99,      99,      99, MEDROCK,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,  SPHERE,      99,  SPHERE,      99,  SPHERE
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,  SPHERE
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,  SPHERE,      99,  SPHERE
	dc.b	      99,      99,      99, BIGROCK,      99,      99, BIGROCK,      99,      99,      99, BIGROCK, MEDROCK,      99, BIGROCK,      99,   BSTAR
	dc.b	      99, BIGROCK, MEDROCK,      99,      99, BIGCRYS,   BSTAR, BIGROCK, BIGROCK,      99,      99, BIGROCK, BURPLEB,      99,   BSTAR,    CUBE
	dc.b	 BURPLEB, BURPLEB, BURPLEB,      99, BURPLEB, BURPLEB, BURPLEB, BURPLEB,      99, BURPLEB, BURPLEB, BIGROCK,   BSTAR,      99, BIGCRYS,      99
	dc.b	 MEDROCK,      99,      99, BIGROCK,   BSTAR,  SPHERE, BIGROCK,      99, BIGROCK, BIGROCK, BUBBLEB,      99, BIGCRYS, MEDROCK, MEDROCK,   BSTAR
	dc.b	 BIGROCK,      99,      99, BIGROCK,      99,      99,      99, BIGCRYS,      99, BIGROCK,   BSTAR,      99, BIGROCK, BIGROCK,      99,      99
	dc.b	 BIGCRYS, BIGROCK,   BSTAR,      99,   BSTAR, BURPLEB, MEDROCK, BIGROCK,      99,      99,  SPHERE, BIGROCK,      99,      99, BIGROCK, BIGROCK
	dc.b	      99,      99, BIGROCK,      99, MEDROCK,   BSTAR,      99, BIGROCK, BIGCRYS,      99,      99,   BSTAR,      99,      99, BIGROCK, BIGCRYS
	dc.b	 BIGROCK, BIGROCK, BIGROCK, BIGROCK, BIGROCK,      99, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK
	dc.b	 BIGROCK, BIGROCK, BIGROCK, BIGROCK, BIGROCK, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK,  SPHERE,      99
	dc.b	      99,      99,      99,   BSTAR,      99, BIGROCK, BIGROCK,   BSTAR,      99,      99, BIGROCK,      99, BIGCRYS,      99, BIGCRYS, BIGROCK
	dc.b	 MEDROCK,      99, MEDROCK,      99,      99,      99, BIGROCK, BIGROCK,      99,      99, BIGROCK,      99,   BSTAR,      99,    CUBE, BIGROCK
	dc.b	 BUBBLEB, BUBBLEB,   BSTAR, MEDROCK, BIGCRYS, BIGROCK, BURPLEB,      99, BIGROCK,      99, BIGROCK, BIGROCK,      99,      99,      99,   BSTAR
	dc.b	  SPHERE,  SPHERE, MEDROCK,  SPHERE,      99, BIGROCK,  SPHERE, BUBBLEB,  SPHERE,      99,  SPHERE,      99, BIGROCK,      99, BIGROCK, BIGCRYS
	dc.b	  SPHERE, BIGCRYS,  SPHERE, BIGCRYS, BIGROCK,      99,  SPHERE, BIGROCK,  SPHERE, MEDROCK,   BSTAR, BIGROCK,   BSTAR,  SPHERE, BIGCRYS,  SPHERE
	dc.b	 BIGROCK,  SPHERE,  SPHERE,  SPHERE, MEDROCK,      99,      99,   BSTAR,      99,      99, BIGROCK,      99, BIGCRYS,      99, MEDROCK,    CUBE
	dc.b	      99,      99,      99,      99,   BSTAR, BIGROCK,      99, BIGROCK, BIGROCK,      99, BIGROCK, BIGROCK,      99, BIGROCK,      99, BIGROCK
	dc.b	 BIGROCK,      99, BIGCRYS,      99,      99, BIGROCK,      99,      99,   BSTAR,  SPHERE, BIGROCK,      99,      99,      99, MEDROCK,      99
	dc.b	 BIGROCK,      99,      99, MEDROCK,   BSTAR, MEDROCK, BIGCRYS,      99, BURPLEB, BIGROCK,   BSTAR,      99, BIGROCK, BIGROCK,      99, BIGROCK
	dc.b	 BUBBLEB,      99, BIGROCK,      99, BIGCRYS,    CUBE,      99, BIGROCK,      99,      99, BIGROCK,      99,      99,      99, BIGCRYS,      99
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB,      99
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB
	dc.b	 BIGROCK,   BSTAR,      99,      99,      99, BIGCRYS,      99,      99, BUBBLEB,   BSTAR, BIGROCK, BIGCRYS,      99,   BSTAR,      99,      99
 	dc.b	      99, BIGROCK,      99, BIGROCK, BIGROCK,      99, BIGROCK,      99,      99,      99, MEDROCK,      99, BIGROCK, MEDROCK,      99,      99
	dc.b	 MEDROCK,   BSTAR,      99,    CUBE,      99,      99,      99, BIGROCK, BIGROCK,      99, BIGROCK,   BSTAR,      99,      99, BIGCRYS,      99
	dc.b	      99,      99,      99,      99,   BSTAR, BIGROCK,      99, BIGROCK,      99,      99, BIGROCK,      99,   BSTAR,      99, BIGCRYS,      99
	dc.b	      99, BIGROCK, BIGROCK,  SPHERE, MEDROCK, BIGROCK,      99, BIGROCK,      99, BIGROCK,   BSTAR,      99, BIGROCK, BIGROCK, MEDROCK,      99
	dc.b	 BIGROCK, BIGROCK, MEDROCK, BUBBLEB,    CUBE, BIGROCK,      99, BURPLEB,      99,      99,      99,      99, BIGROCK,      99, BIGROCK,      99
	dc.b	 MEDROCK, BIGCRYS,      99, BIGCRYS,      99, BIGROCK,      99,   BSTAR,      99, BIGCRYS, BIGROCK,      99,      99, BIGROCK,      99, BIGROCK
	dc.b	      99, BIGCRYS,      99,      99,      99,      99, BIGROCK,   BSTAR,      99,  SPHERE, BIGROCK,      99, MEDROCK,      99, BIGROCK, BIGROCK
	dc.b	 BIGROCK, BIGROCK, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK
	dc.b	 BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK, BIGROCK, MEDROCK, BIGROCK, BIGROCK, BIGROCK
	dc.b	      99,      99,   BSTAR,      99, BIGROCK,      99, BUBBLEB, MEDROCK,      99,      99, BIGCRYS,      99, BURPLEB,      99, BIGROCK,      99
	dc.b	 BIGROCK,      99,      99,   BSTAR,   BSTAR, BIGROCK, BIGCRYS, BIGROCK,      99,   BSTAR, BIGCRYS,      99, BIGCRYS,      99,      99, MEDROCK
	dc.b	 BURPLEB, BURPLES, BURPLEB, MEDROCK,   BSTAR, BURPLEB, BIGROCK,   BSTAR, BURPLEB, BURPLEB, BURPLEB, BURPLEB,      99, BURPLEB, BIGCRYS,      99
	dc.b	 MEDROCK, BIGROCK,      99, BIGCRYS,      99, BIGROCK,   BSTAR, BIGROCK, BIGROCK,      99, BIGROCK,      99,  SPHERE, BIGROCK,      99, BIGROCK
	dc.b	 MEDROCK,      99, BIGROCK, BIGROCK,      99,      99,      99,      99,   BSTAR,      99, BUBBLEB, BIGROCK,      99,    CUBE,      99, BIGCRYS
	dc.b	 BIGROCK,   BSTAR,      99,      99,   BSTAR,      99,      99, BIGROCK,      99,      99, MEDROCK, BIGROCK,      99, BIGROCK,      99,   BSTAR
	dc.b	 MEDROCK,      99,      99,      99,      99,      99, BUBBLEB,  SPHERE,   BSTAR, BIGROCK,      99,      99, BIGCRYS,      99, BIGROCK,   BSTAR
	dc.b	      99,      99, MEDROCK,      99, BIGROCK,      99,   BSTAR,      99, BIGCRYS,      99,      99, BIGROCK, BIGROCK,      99, BIGROCK,      99
	dc.b	      99,    CUBE,      99,      99,      99,   BSTAR, BIGROCK,      99, BIGCRYS, BIGROCK,      99,   BSTAR,      99,      99, BIGROCK,      99
	dc.b	      99, MEDROCK, BIGROCK, MEDROCK, BIGROCK,      99, BIGROCK,      99, BUBBLEB, BIGCRYS,  SPHERE, BURPLEB,      99, MEDROCK, BIGROCK,      99
	dc.b	      99, BIGROCK,      99,   BSTAR, BIGROCK, BIGROCK, BIGROCK,   BSTAR,      99,      99, BIGROCK,    CUBE, BIGCRYS,      99,      99,      99
	dc.b	 BIGROCK,      99,      99,      99, BIGROCK,      99,      99,   BSTAR, BIGROCK, MEDROCK, BIGROCK,      99, BIGCRYS, BIGROCK, BIGROCK,      99
	dc.b	  SPHERE,      99, BIGCRYS,      99,   BSTAR, BIGROCK, BUBBLEB,      99, BIGCRYS,      99, BIGROCK,      99, BIGROCK, BIGROCK,      99,   BSTAR
	dc.b	 BIGROCK,      99, BIGROCK, MEDROCK,      99, BIGROCK,      99, BIGROCK,      99,      99,      99,      99,      99,      99,      99,      99


;*****************************************************************************************************
tlistsp1::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$05,$0B,$0A,$00,$01,$07,$02,$0B,$0C,$00,$04,$05,$03,$01,$07,$02,$03,$01,$07,$09,$0B,$0A,$0C,$0B,$00,$04,$01,$02,$06,$09,$0C
	dc.b	$00,$04,$01,$02,$00,$04,$01,$09,$0B,$0A,$0D,$0B,$06,$07,$02,$0A,$03,$01,$07,$09,$0D,$0C,$00,$05,$00,$01,$07,$02,$0A,$03,$01,$02
	dc.b	$0B,$03,$04,$01,$02,$0B,$0D,$03,$01,$02,$00,$04,$05,$0B,$03,$05,$0D,$0A,$0C,$0B,$06,$08,$02,$03,$01,$07,$08,$02,$03,$04,$01,$07
	dc.b	$08,$02,$0C,$06,$02,$0B,$0D,$06,$09,$0D,$06,$08,$09,$0C,$0B,$0A,$03,$05,$0D,$00,$01,$02,$06,$07,$02,$0C,$0B,$03,$05,$00,$01,$09
	dc.b	$0C,$03,$04,$05,$03,$05,$03,$05,$0B,$0A,$00,$01,$07,$09,$0C,$06,$02,$0B,$0D,$06,$08,$02,$03,$05,$0B,$0D,$06,$09,$0B,$0A,$0C,$00
	dc.b	$01,$07,$02,$0D,$0B,$03,$04,$01,$07,$02,$06,$07,$02,$0D,$0B,$0A,$0C,$0A,$00,$04,$05,$00,$05,$0C,$03,$05,$0C,$0A,$00,$01,$08,$02
	dc.b	$0C,$00,$05,$03,$05,$0A,$00,$01,$08,$07,$08,$02,$0A,$0D,$06,$02,$0C,$0D,$03,$01,$02,$03,$05,$0B,$0D,$00,$01,$02,$0C,$06,$08,$09
	dc.b	$0B,$06,$08,$07,$08,$09,$00,$01,$08,$07,$09,$0C,$00,$04,$01,$07,$09,$03,$04,$01,$07,$08,$02,$0B,$00,$04,$05,$06,$09,$0B,$0A,$0C
;end of space level
	dc.b	$00,$04,$05,$0B,$00,$04,$05,$0C,$0B,$00,$01,$07,$02,$06,$07,$02,$0B,$00,$05,$0B,$0D,$06,$09,$0D,$06,$08,$07,$09,$0B,$0D,$03,$04
	dc.b	$05,$0D,$06,$08,$07,$08,$02,$06,$08,$02,$0A,$00,$05,$0B,$06,$09,$0C,$06,$07,$08,$09,$0B,$0D,$0A,$03,$05,$0A,$03,$01,$09,$0C,$00
	dc.b	$04,$01,$08,$09,$0A,$03,$01,$02,$00,$04,$05,$0B,$0A,$06,$07,$08,$09,$0D,$0B,$03,$01,$09,$00,$01,$08,$09,$0B,$06,$07,$09,$03,$04

;enemies for space level 1		32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;big crystal
;big star
;purple rocks
;burple
;bubble
;cube
;sphere
elistsp1::
	dc.b	  PROCKB,      99,      99,      99,  PROCKB,      99,      99,      99,  PROCKB,      99,   BSTAR,      99,  PROCKB,      99,  PROCKB,      99
	dc.b	   BSTAR,  PROCKM, BIGCRYS,      99,  PROCKB,      99,      99, BIGCRYS,   MSTAR,      99,  SPHERE,  PROCKB,      99,   BSTAR,  PROCKB, BIGCRYS
	dc.b	      99,      99,  PROCKB,  PROCKB,      99,  PROCKB,    CUBE,  PROCKM, BURPLEB,  PROCKB,      99,   BSTAR,  PROCKB, BIGCRYS,  PROCKB,      99
	dc.b	      99,  PROCKM,   MSTAR,  PROCKB, BUBBLEB,  PROCKB,   BSTAR,      99, BIGCRYS,      99,  SPHERE,      99,  PROCKB,  PROCKB,      99,  PROCKB
	dc.b	  PROCKB,  PROCKB,      99,   BSTAR,   MSTAR,      99, BIGCRYS, BIGCRYS,  PROCKB,  PROCKB,   BSTAR,    CUBE,  PROCKM,  PROCKM,  PROCKB,      99
	dc.b	  PROCKB,      99,  PROCKB,      99,   BSTAR,      99,  PROCKB,   MSTAR,  PROCKB,  PROCKB,      99,  PROCKB,      99,      99, BIGCRYS,  PROCKB
	dc.b	  PROCKB,      99,      99, BIGCRYS,  SPHERE,  PROCKM,   BSTAR,  PROCKB,      99,  PROCKB, BIGCRYS,  PROCKB,      99,      99,  PROCKB, BUBBLEB
	dc.b	   BSTAR,  PROCKB,      99,      99,  PROCKB,  PROCKB,  PROCKM,      99, BURPLEB,  PROCKB,   MSTAR,  PROCKB,    CUBE,      99,  PROCKM,  PROCKB
	dc.b	      99,      99,  PROCKB,  PROCKB,   BSTAR,  PROCKM,      99,  PROCKB,  PROCKB,  PROCKB,      99,  PROCKB,  PROCKB,      99, BIGCRYS,      99
	dc.b	  PROCKB,   BSTAR,  PROCKB,      99,   BSTAR,      99,  PROCKM, BIGCRYS,  PROCKB, BIGCRYS,  SPHERE,      99,  PROCKB, BUBBLEB,      99,  PROCKB
	dc.b	      99,  PROCKB,  PROCKB,      99,      99,   MSTAR,  PROCKB,  PROCKB,  PROCKB, BIGCRYS,      99, BIGCRYS,      99,   BSTAR,  PROCKB,   BSTAR
	dc.b	  PROCKM,  PROCKB,    CUBE,      99,      99,  PROCKB, BURPLEB,  PROCKB,  PROCKM,  PROCKB,      99,  PROCKB,      99,  PROCKB,      99,   BSTAR
	dc.b	  PROCKB,   MSTAR,  PROCKB,      99,  PROCKB, BURPLEB, BIGCRYS,  PROCKM,   BSTAR,  PROCKB, BUBBLEB,   BSTAR,  PROCKM,      99,  SPHERE,      99
	dc.b	   BSTAR,  PROCKB,  PROCKB,      99,      99,  PROCKB,  PROCKB,  PROCKB,  PROCKB,      99, BIGCRYS,      99, BIGCRYS,  PROCKB,      99,  PROCKB
	dc.b	   MSTAR,      99,   BSTAR,  PROCKM,  PROCKB,      99,      99,    CUBE,  PROCKB,   BSTAR,  PROCKB,      99, BIGCRYS,  PROCKB,  PROCKB,      99
	dc.b	  PROCKB,      99,  PROCKB,  PROCKB,      99,      99,  PROCKB, BUBBLEB,      99,  SPHERE,  PROCKB,      99,      99,  PROCKB,  PROCKM,   BSTAR
	dc.b	      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99
	dc.b	      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99
	dc.b	      99, BUBBLEB,      99,      99,      99,      99,      99,      99,      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99
	dc.b	      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99,      99, BUBBLEB,      99,      99
	dc.b	  PROCKM,  PROCKB,  PROCKB,      99,  PROCKM, BIGCRYS,   MSTAR,  PROCKB,  PROCKB,      99,      99,  PROCKB, BURPLEB,      99,   BSTAR,    CUBE
	dc.b	      99,   BSTAR,  PROCKB,      99,  PROCKB,  PROCKB,      99,  PROCKB,      99,  PROCKM,      99,  PROCKB,   BSTAR,      99, BIGCRYS,      99
	dc.b	  PROCKB,      99,      99,  PROCKB,   MSTAR,  SPHERE,  PROCKB,      99,  PROCKB,  PROCKB, BUBBLEB,      99, BIGCRYS,      99,      99,   BSTAR
	dc.b	  PROCKB,   BSTAR,      99,      99,  PROCKB,      99,      99,  PROCKB,   BSTAR,  PROCKM,  PROCKB,   MSTAR,      99,  PROCKM,      99,    CUBE
	dc.b	      99, BIGCRYS,  PROCKB,      99,      99, BURPLEB,  PROCKB,  PROCKB,  PROCKB,      99,  PROCKB,  PROCKB,      99,  PROCKM,      99,  PROCKB
	dc.b	      99,   BSTAR,  PROCKB,   BSTAR,  SPHERE,      99,      99,      99,  PROCKM,  PROCKB,      99,      99, BIGCRYS,  PROCKB,      99,  PROCKB
	dc.b	  PROCKB, BIGCRYS,      99,      99,      99,  PROCKB,   BSTAR,      99, BUBBLEB,  PROCKB,      99,  PROCKB,    CUBE,      99,      99,   MSTAR
	dc.b	   BSTAR,   BSTAR,   MSTAR,   BSTAR,  SPHERE,   BSTAR,   BSTAR,   MSTAR,   BSTAR,   BSTAR,   BSTAR, BURPLEB,   BSTAR,   MSTAR,   BSTAR,      99
	dc.b	 BIGCRYS,  PROCKB,   BSTAR,      99,   BSTAR, BURPLEB,  PROCKB,  PROCKB,      99,      99,  SPHERE,  PROCKB,      99,      99,  PROCKB,  PROCKB
	dc.b	      99,  PROCKM,  PROCKB,      99,      99,   MSTAR,      99,  PROCKB, BIGCRYS,      99,      99,   BSTAR,      99,      99,  PROCKB, BIGCRYS
	dc.b	      99,  PROCKM,   BSTAR,  PROCKB,      99,      99,    CUBE,      99,  PROCKB,  PROCKB,  PROCKM,      99, BUBBLEB,      99,   BSTAR,  PROCKB
	dc.b	  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  PROCKM,  SPHERE
	dc.b	  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS
	dc.b	  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS,  PROCKS
	dc.b	      99,      99,      99,      99,  PROCKB,      99,   BSTAR,      99,   MSTAR,  PROCKM,   BSTAR,      99,      99,      99,      99,      99
	dc.b	  PROCKB,      99,   BSTAR,      99,  PROCKB,      99,      99, BIGCRYS,      99,      99,  PROCKB,      99,   BSTAR,  PROCKB,      99,  SPHERE
	dc.b	  PROCKB,   BSTAR,      99,      99,  PROCKM, BIGCRYS,      99,      99, BUBBLEB,   MSTAR,  PROCKB, BIGCRYS,      99,   BSTAR,      99,  PROCKM
 	dc.b	      99,  PROCKB,      99,  PROCKB,  PROCKB,      99,  PROCKB,      99,      99,      99,  PROCKM,      99,  PROCKB,      99,      99,      99
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB,    CUBE,      99, BUBBLEB, BUBBLEB,  PROCKB,  PROCKB,      99,  PROCKB,   BSTAR, BUBBLEB, BUBBLEB, BIGCRYS, BUBBLEB
	dc.b	 BURPLEB, BURPLEB,      99, BURPLEB, BURPLEB,  PROCKB,      99,  PROCKB, BURPLEB, BURPLEB,  PROCKB, BURPLEB,   BSTAR, BURPLEB, BIGCRYS,      99
	dc.b	      99,  PROCKB,  PROCKB,  SPHERE,  PROCKM,  PROCKB,      99,  PROCKB,  PROCKM,  PROCKB,   BSTAR,      99,  PROCKB,  PROCKB,      99,      99
	dc.b	  PROCKB,  PROCKB, BURPLES, BUBBLEB,    CUBE,  PROCKB, BURPLES, BURPLEB, BURPLES,      99, BURPLES, BURPLES,  PROCKB, BURPLES,      99, BURPLES
	dc.b	  PROCKM, BIGCRYS,      99, BIGCRYS, BURPLES,  PROCKB, BURPLES,   MSTAR,      99, BIGCRYS,  PROCKB,      99, BURPLES,  PROCKB,      99,  PROCKB
	dc.b	      99, BIGCRYS, BURPLES,      99,      99,      99,  PROCKB,   BSTAR,      99,      99,  PROCKB,      99,      99,      99,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,      99,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	      99,  SPHERE,      99,      99,   BSTAR,      99,  PROCKB,      99,      99,      99,  PROCKB,      99,      99,      99, BIGCRYS,      99
	dc.b	      99,  PROCKB, BURPLES, BIGCRYS,      99,  PROCKB,   BSTAR,  PROCKB,  PROCKB,      99,  PROCKB,      99,      99,  PROCKB,      99,  PROCKB
	dc.b	  PROCKM,      99,  PROCKB,  PROCKB,      99,      99, BURPLES,      99,   BSTAR,      99, BUBBLEB,  PROCKB,      99,    CUBE,      99, BIGCRYS
	dc.b	  PROCKB,   BSTAR,      99,      99,   BSTAR,      99, BURPLES,  PROCKB,      99,  PROCKM,  PROCKM,  PROCKB,      99,  PROCKB,      99,   MSTAR
	dc.b	  PROCKB,   BSTAR,      99,    CUBE,  PROCKB,  PROCKB,      99,  PROCKB,    CUBE,      99, BUBBLEB,      99,    CUBE,      99,      99,   BSTAR
	dc.b	 BIGCRYS,  PROCKB,      99,      99,  PROCKM,      99,  PROCKM,   BSTAR,  PROCKM,      99,  PROCKB,   BSTAR,      99,      99,      99, BIGCRYS
	dc.b	      99,  PROCKB,      99,      99, BIGCRYS,      99,   BSTAR,  SPHERE,      99,      99,      99,      99,  PROCKB,  PROCKB, BUBBLEB,      99
	dc.b	  PROCKB, BURPLEB, BURPLEB, BURPLEB,   MSTAR,      99, BUBBLEB,  PROCKB,      99,  PROCKB,   BSTAR,      99, BIGCRYS,      99,  PROCKB,  PROCKB
	dc.b	      99,   BSTAR,      99,      99,      99,  PROCKB,      99,      99,   BSTAR,      99,    CUBE,   MSTAR,  PROCKM,      99,  PROCKM,      99
	dc.b	  PROCKB, BIGCRYS,  PROCKM,      99, BUBBLEB,      99,      99,   BSTAR,  PROCKB,      99, BURPLEB,  PROCKB,  PROCKB,  PROCKB,  PROCKB,      99
	dc.b	  PROCKM,    CUBE,      99,      99,  PROCKM,   MSTAR,  PROCKB,      99, BIGCRYS,  PROCKB,      99,   BSTAR,      99,      99,  PROCKB,      99
	dc.b	      99,      99,  PROCKB,      99,  PROCKB,      99,  PROCKB,      99, BUBBLEB, BIGCRYS,  SPHERE, BURPLEB,      99,  PROCKB,  PROCKM,      99
	dc.b	      99,  PROCKB,      99,   BSTAR,  PROCKB,  PROCKB,  PROCKB,   BSTAR,      99,      99,  PROCKB,    CUBE, BIGCRYS,      99,      99,      99
	dc.b	  PROCKB,      99,      99,      99,  PROCKB,  PROCKM,      99,   BSTAR,  PROCKB,  PROCKB,  PROCKB,      99, BIGCRYS,  PROCKM,  PROCKB,      99
	dc.b	  SPHERE,      99, BIGCRYS,      99,   MSTAR,  PROCKB, BUBBLEB,      99, BIGCRYS,      99,  PROCKB,      99,  PROCKB,  PROCKB,      99,   BSTAR
	dc.b	  PROCKB,      99,  PROCKB,  PROCKB,      99,  PROCKM,      99,  PROCKB,      99,      99,      99,      99,      99,      99,      99,      99


;*****************************************************************************************************
tlistsp2::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$04,$01,$02,$06,$08,$07,$02,$0A,$0D,$0C,$0A,$0C,$06,$02,$0D,$03,$01,$09,$0D,$0A,$00,$05,$00,$04,$05,$03,$01,$09,$0B,$0A,$00
	dc.b	$04,$01,$08,$02,$0B,$0D,$03,$04,$05,$0A,$00,$01,$02,$03,$04,$01,$09,$0A,$03,$05,$00,$04,$05,$06,$09,$0A,$06,$02,$00,$05,$0C,$00
	dc.b	$04,$01,$07,$02,$0B,$0C,$03,$01,$02,$0A,$0C,$0D,$03,$04,$01,$08,$02,$0D,$0B,$00,$01,$09,$0C,$0D,$06,$09,$00,$01,$07,$02,$0C,$00
	dc.b	$05,$0A,$0D,$0C,$0D,$06,$07,$02,$0A,$00,$01,$02,$0B,$06,$02,$00,$01,$09,$06,$02,$0B,$0D,$06,$09,$0D,$06,$09,$0B,$0D,$0A,$0D,$0B
	dc.b	$03,$04,$05,$00,$04,$05,$03,$05,$0C,$03,$01,$07,$02,$0B,$0A,$0D,$06,$02,$0C,$03,$05,$0B,$03,$04,$01,$08,$09,$0C,$06,$09,$0C,$03
	dc.b	$01,$02,$06,$08,$09,$03,$01,$07,$08,$09,$0A,$06,$09,$0D,$06,$09,$0C,$0A,$00,$05,$06,$09,$0C,$06,$02,$0A,$06,$07,$02,$00,$05,$03
	dc.b	$05,$0B,$0D,$0B,$03,$04,$01,$08,$07,$02,$00,$01,$02,$0D,$00,$04,$01,$09,$0C,$00,$04,$01,$09,$00,$05,$0A,$03,$04,$05,$00,$01,$08
	dc.b	$02,$0D,$03,$05,$0C,$06,$02,$0A,$06,$02,$0C,$06,$08,$02,$0D,$0C,$0B,$0D,$06,$09,$0A,$0B,$06,$02,$0D,$03,$05,$0C,$0A,$06,$02,$00
;end of space level
	dc.b	$05,$0B,$06,$02,$0C,$03,$01,$09,$0C,$03,$01,$07,$08,$09,$00,$01,$07,$09,$0C,$00,$05,$0B,$06,$08,$09,$0B,$06,$08,$09,$00,$01,$02
	dc.b	$0A,$0B,$0D,$0A,$0C,$0D,$06,$02,$03,$01,$09,$06,$02,$0C,$06,$09,$0C,$0B,$00,$01,$09,$0B,$06,$07,$08,$07,$09,$0D,$0A,$00,$05,$03
	dc.b	$04,$01,$09,$00,$04,$01,$09,$0D,$0B,$0D,$0B,$0D,$03,$05,$06,$02,$0B,$00,$04,$05,$0B,$0D,$0A,$0D,$00,$04,$05,$00,$05,$0C,$03,$05

;enemies for space level 2			32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;big crystal
;big star
;burple
;bubble
;pebble
;cube
;sphere
elistsp2::
	dc.b	 PEBBLEB,      99,      99,      99, PEBBLEB,      99,      99, PEBBLEB, PEBBLES,      99,      99,      99, PEBBLEB,      99, PEBBLEB,      99
	dc.b	      99, PEBBLEB, BIGCRYS,      99, PEBBLEM,      99, BUBBLEB, BIGCRYS,   BSTAR,      99,  SPHERE, PEBBLEB,      99,   BSTAR, PEBBLEB, BIGCRYS
	dc.b	      99,      99, PEBBLES, PEBBLEB,      99,      99,    CUBE, PEBBLEM,      99, PEBBLEB,      99,   MSTAR, PEBBLEB, BIGCRYS, PEBBLEB,      99
	dc.b	      99, PEBBLEB,   BSTAR, PEBBLEM, BUBBLEB, PEBBLES,   BSTAR, BURPLES, BIGCRYS,      99,  SPHERE,      99, PEBBLEB, PEBBLEB,      99, PEBBLEB
	dc.b	 PEBBLEB, PEBBLEB,      99,   BSTAR,   BSTAR,      99, BIGCRYS, BIGCRYS, PEBBLEB, PEBBLEB,   BSTAR,    CUBE, PEBBLEB, BURPLES, PEBBLEM,      99
	dc.b	 PEBBLEB,      99, PEBBLEB,      99,   BSTAR,      99, PEBBLES,   BSTAR, PEBBLEB, PEBBLEB,      99, PEBBLEB, BURPLES,      99, BIGCRYS, PEBBLEB
	dc.b	 PEBBLEB,      99,      99, BIGCRYS,  SPHERE, PEBBLEB,   BSTAR, PEBBLEM,      99, PEBBLEB, BIGCRYS, PEBBLEB,      99, PEBBLEM, PEBBLEB, BUBBLEB
	dc.b	   BSTAR, PEBBLES,      99,      99, PEBBLEB, PEBBLEB, BURPLES,      99, BURPLEB, PEBBLEB,   BSTAR, PEBBLEB,    CUBE,      99, PEBBLEB, PEBBLEB
	dc.b	      99,      99, PEBBLEM, PEBBLEB,   BSTAR,      99,      99, PEBBLEB, PEBBLEB, PEBBLES,      99, PEBBLEB, PEBBLEB, PEBBLEM, BIGCRYS,      99
	dc.b	 PEBBLEB,   BSTAR, PEBBLEB,      99,   BSTAR,      99, PEBBLEB, BIGCRYS, PEBBLEM, BIGCRYS,  SPHERE,      99, PEBBLEB, BUBBLEB,      99, PEBBLEB
	dc.b	      99, PEBBLES, PEBBLEB,      99,      99,   BSTAR, PEBBLEB, PEBBLEB, PEBBLEB, BIGCRYS,      99, BIGCRYS, PEBBLEM,   BSTAR, PEBBLEB,   BSTAR
	dc.b	 PEBBLEB, PEBBLEM,    CUBE,      99,      99, PEBBLEB, BURPLEB, PEBBLEB,      99, PEBBLEB,      99, PEBBLEB,      99, PEBBLES, BURPLES,   BSTAR
	dc.b	 PEBBLEB,   BSTAR, PEBBLEB,      99, PEBBLEB, BURPLEB, BIGCRYS, PEBBLEB,   BSTAR, PEBBLEM, BUBBLEB,   BSTAR,      99,      99,  SPHERE,      99
	dc.b	   BSTAR, PEBBLEB, PEBBLEB,      99,      99, PEBBLEB, PEBBLEB, PEBBLEB, PEBBLES,      99, BIGCRYS,      99, BIGCRYS, PEBBLEB, PEBBLEM, PEBBLEB
	dc.b	   BSTAR,      99,   BSTAR, PEBBLEB, PEBBLEM,      99,      99,    CUBE, PEBBLEB,   BSTAR, PEBBLEB,      99, BIGCRYS, PEBBLEB, PEBBLES, PEBBLEM
	dc.b	 PEBBLEB,      99, PEBBLEB, PEBBLEB,      99,      99, PEBBLEB, BUBBLEB,      99,  SPHERE, PEBBLEB,      99,      99, PEBBLEB,      99,   BSTAR
	dc.b	 PEBBLEB, PEBBLEM, PEBBLES,      99,      99, BIGCRYS,   BSTAR, PEBBLEB, PEBBLEB, BURPLES,      99, PEBBLEB, BURPLEB,      99,   BSTAR,    CUBE
	dc.b	      99,   BSTAR, PEBBLEB,      99, PEBBLEB, PEBBLEB,      99, PEBBLEB,      99, PEBBLEB,      99, PEBBLEM,   BSTAR,      99, BIGCRYS,      99
	dc.b	 PEBBLEB,      99,      99, PEBBLEB,   BSTAR,  SPHERE, PEBBLEB, PEBBLEM, PEBBLEB, PEBBLEB, BUBBLEB,      99, BIGCRYS,      99,      99,   BSTAR
	dc.b	 PEBBLEB,   BSTAR, PEBBLEM,      99, PEBBLEB,      99,      99, PEBBLEB,   BSTAR, PEBBLEB, PEBBLEM,   BSTAR,      99,      99,      99,    CUBE
	dc.b	 BURPLES, BIGCRYS, PEBBLES,      99,      99, BURPLEB, PEBBLEB, PEBBLEB, PEBBLEB,      99, PEBBLEB, PEBBLEB,      99,      99,      99, PEBBLEB
	dc.b	      99,   BSTAR, PEBBLEB,   BSTAR,  SPHERE,      99,      99,      99, PEBBLEB, PEBBLEB,      99,      99, BIGCRYS, PEBBLEB,      99, PEBBLEM
	dc.b	 PEBBLEB, BIGCRYS,      99,      99,      99, PEBBLEB,   BSTAR,      99, BUBBLEB, PEBBLEB, PEBBLEM, PEBBLEB,    CUBE,      99,      99,   BSTAR
	dc.b	 PEBBLEB, PEBBLEM,      99, PEBBLEB,      99, BURPLES,      99, BIGCRYS,      99, PEBBLEB,   BSTAR,      99, PEBBLEB, PEBBLEB,      99,      99
	dc.b	 BIGCRYS, PEBBLEM,   BSTAR,      99,   BSTAR, BURPLEB, PEBBLEB, PEBBLEB,      99,      99,  SPHERE, PEBBLES,      99,      99, PEBBLEB, PEBBLEB
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB,      99, BUBBLEB, PEBBLEB, BIGCRYS
	dc.b	      99, PEBBLEB,   BSTAR, PEBBLEM,      99,      99,    CUBE,      99, PEBBLEB, PEBBLEB, PEBBLEM,      99, BUBBLEB, PEBBLEM,   BSTAR, PEBBLEB
	dc.b	 BIGCRYS,      99, PEBBLEB,      99,      99, PEBBLEB,      99,      99,      99, BIGCRYS,      99,      99, PEBBLEB,      99,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,      99,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,      99,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99,      99,  SPHERE,      99,      99
	dc.b	 PEBBLEB,      99,      99,      99,      99, BIGCRYS,      99,      99, BUBBLEB,      99, PEBBLEB, BIGCRYS,      99,   BSTAR,      99,      99
 	dc.b	      99, PEBBLEB, PEBBLEM, PEBBLEB, PEBBLEB,      99, PEBBLEB,      99,      99,      99, PEBBLEM,      99, PEBBLEB,      99,      99, BURPLES
	dc.b	      99,   BSTAR,      99,    CUBE,      99, PEBBLEM,      99, PEBBLEB, PEBBLEB,      99, PEBBLEB,   BSTAR,      99,      99, BIGCRYS,      99
	dc.b	 BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB, PEBBLEB, BURPLEB, BURPLEB, PEBBLEB, BURPLEB,   BSTAR,      99, BIGCRYS,      99
	dc.b	      99, PEBBLEB, PEBBLES,      99, PEBBLEM, PEBBLEB,      99, PEBBLEB,      99, PEBBLEB,   BSTAR, BURPLES, PEBBLEB, PEBBLEB,      99, PEBBLEM
	dc.b	 BIGCRYS, PEBBLEM,   BSTAR,      99,   BSTAR, BURPLEB, PEBBLEB, PEBBLEB,      99,      99,  SPHERE, PEBBLES,      99,      99, PEBBLEB, PEBBLEB
	dc.b	 PEBBLEM, BIGCRYS, PEBBLEM, BIGCRYS,      99, PEBBLEB,      99,   BSTAR,      99, BIGCRYS, PEBBLEB,      99,      99, PEBBLEB,      99, PEBBLEB
	dc.b	      99, BIGCRYS,      99,      99,      99,      99, PEBBLEB,   BSTAR,      99,  SPHERE, PEBBLEB,      99,      99,      99, PEBBLEB, PEBBLEB
	dc.b	      99,      99,   BSTAR, PEBBLEM,      99,      99, PEBBLEB, PEBBLEM, BIGCRYS,      99,   BSTAR, PEBBLEB, BURPLES,      99,      99, PEBBLEB
	dc.b	      99,      99,      99,      99,      99,   BSTAR,      99,      99, BIGCRYS,      99, PEBBLEB,   BSTAR,    CUBE, PEBBLEM, PEBBLEB, PEBBLEB
	dc.b	 BURPLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BUBBLEB, BURPLEB
	dc.b	 BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BUBBLEB, BURPLEB
	dc.b	 BUBBLEB, BURPLEB, BURPLEB, BURPLEB, BUBBLEB, BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB
	dc.b	 BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BURPLEB, BUBBLEB, BURPLEB, BUBBLEB, BURPLEB, BURPLEB, BUBBLEB
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB,      99, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,      99,      99,      99, PEBBLES,      99, PEBBLEB, BURPLES,   BSTAR
	dc.b	      99, PEBBLEB,      99, BIGCRYS,      99, PEBBLEB,      99,  SPHERE, PEBBLEM, BURPLEB,      99, PEBBLEB,      99,   BSTAR,      99, BIGCRYS
	dc.b	 PEBBLEB,   BSTAR,      99,      99, PEBBLEB, PEBBLEB,      99, PEBBLEB,   BSTAR,      99, BUBBLEB,      99,      99, PEBBLEM,      99,   BSTAR
	dc.b	   BSTAR,      99, BIGCRYS,      99,      99,      99, PEBBLEB,    CUBE,      99,   BSTAR, PEBBLEB,   BSTAR, BURPLES, PEBBLEM, PEBBLEB,      99
	dc.b	 BIGCRYS, PEBBLEB,      99,      99, PEBBLEM,      99,      99,   BSTAR,      99,      99, PEBBLEB,   BSTAR,      99,      99,      99, BIGCRYS
	dc.b	      99, PEBBLES,      99,      99, BIGCRYS,      99,   BSTAR,  SPHERE,      99,      99,      99,      99, PEBBLEB, PEBBLEB, BUBBLEB,      99
	dc.b	 PEBBLEB,      99,      99,      99,   BSTAR,      99,      99, PEBBLEB,      99, PEBBLEB,   BSTAR,      99, BIGCRYS, PEBBLEM, PEBBLEB, PEBBLEB
	dc.b	      99,   BSTAR, PEBBLEM,      99, BURPLES, PEBBLEB,      99,      99,   BSTAR,      99,    CUBE,   BSTAR, PEBBLEM,      99,      99,      99
	dc.b	 PEBBLEB, BIGCRYS,      99,      99,      99,      99,      99,   BSTAR, PEBBLEB,      99, BURPLEB, PEBBLEB, PEBBLEB, PEBBLEB, PEBBLEB,      99
	dc.b	      99,      99,      99,      99,      99,      99, BUBBLEB,  SPHERE,   BSTAR, PEBBLEB,      99,      99, BIGCRYS,      99, PEBBLES,   BSTAR
	dc.b	 PEBBLEM,      99, PEBBLEB,      99, PEBBLEM,      99,   BSTAR, PEBBLEM, BIGCRYS,      99,      99, PEBBLEB, PEBBLEB,      99, PEBBLEB,      99
	dc.b	      99,    CUBE,      99,      99,      99,   BSTAR, PEBBLEB,      99, BIGCRYS, PEBBLEB,      99,   BSTAR,      99,      99, PEBBLEB,      99
	dc.b	      99,      99, PEBBLEB,      99, PEBBLEB,      99, PEBBLEB,      99, BUBBLEB, BIGCRYS,  SPHERE, BURPLEB,      99, PEBBLEB, PEBBLEM, PEBBLEM
	dc.b	      99, PEBBLEB,      99,   BSTAR, PEBBLEB, PEBBLES, PEBBLEB,   BSTAR,      99,      99, PEBBLEB,    CUBE, BIGCRYS, PEBBLEM,      99,      99
	dc.b	 PEBBLEB,      99,      99,      99, PEBBLEB,      99,      99,   BSTAR, PEBBLEB, PEBBLEB, PEBBLEB,      99, BIGCRYS, PEBBLEM, PEBBLEB,      99
	dc.b	  SPHERE,      99, BIGCRYS,      99,   BSTAR, PEBBLEB, BUBBLEB,      99, BIGCRYS,      99, PEBBLEB,      99, PEBBLEB, PEBBLEB,      99,   BSTAR
	dc.b	 PEBBLEB,      99, PEBBLEB, PEBBLEB,      99, PEBBLEM,      99, PEBBLEB,      99,      99,      99,      99,      99,      99,      99,      99


;*****************************************************************************************************
tlistsp3::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$04,$01,$09,$0C,$0B,$00,$04,$01,$08,$09,$0B,$00,$01,$07,$08,$02,$06,$02,$0C,$00,$01,$08,$02,$0A,$0B,$03,$05,$0A,$03,$01,$02
	dc.b	$0C,$0B,$00,$04,$05,$03,$05,$00,$04,$01,$09,$0A,$0B,$0A,$0B,$0D,$06,$02,$0B,$0C,$00,$05,$0D,$00,$01,$09,$06,$02,$0A,$06,$07,$09
	dc.b	$06,$02,$0A,$00,$01,$08,$02,$0D,$00,$05,$0C,$03,$01,$07,$02,$0A,$06,$08,$09,$0B,$0A,$0B,$06,$09,$0D,$06,$09,$06,$02,$00,$01,$07
	dc.b	$02,$0D,$03,$01,$07,$08,$07,$09,$00,$05,$0C,$03,$04,$05,$0B,$00,$01,$09,$0D,$0C,$06,$02,$0A,$0C,$0B,$00,$01,$08,$02,$0C,$0A,$0D
	dc.b	$0A,$00,$04,$05,$00,$04,$01,$09,$0C,$0A,$06,$02,$0C,$00,$04,$01,$02,$0C,$03,$04,$05,$03,$05,$0C,$06,$09,$0A,$00,$04,$05,$00,$05
	dc.b	$06,$02,$00,$05,$03,$04,$01,$08,$07,$09,$0B,$0C,$0A,$06,$08,$09,$0A,$06,$02,$00,$01,$07,$02,$0C,$00,$05,$03,$01,$09,$0C,$0A,$0B
	dc.b	$0A,$0D,$03,$01,$08,$09,$0B,$03,$04,$01,$08,$02,$0C,$00,$04,$01,$08,$09,$0B,$0D,$03,$04,$01,$09,$0C,$0D,$0B,$03,$01,$09,$0D,$03
	dc.b	$05,$0B,$00,$04,$01,$09,$0C,$0A,$0C,$0B,$0D,$06,$02,$0B,$0C,$0A,$0D,$0B,$0C,$0D,$0C,$00,$04,$01,$07,$02,$0D,$00,$05,$06,$08,$07
;end of space level
	dc.b	$02,$0D,$03,$01,$07,$08,$02,$0B,$03,$01,$09,$06,$08,$09,$03,$01,$08,$07,$09,$0D,$00,$04,$01,$08,$09,$06,$02,$0D,$0B,$0D,$06,$09
	dc.b	$0B,$00,$01,$07,$02,$00,$01,$02,$00,$04,$01,$09,$03,$04,$01,$08,$07,$02,$06,$08,$02,$03,$04,$05,$0D,$03,$04,$01,$02,$03,$05,$0D
	dc.b	$06,$09,$03,$05,$03,$01,$09,$0A,$06,$08,$07,$02,$00,$01,$02,$00,$04,$05,$03,$04,$01,$07,$08,$07,$02,$00,$04,$01,$02,$0D,$00,$04

;enemies for space level 3			32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;big rock
;big crystal
;big star
;purple rocks
;burple
;bubble
;pebble
;cube
;tri
elistsp3::
	dc.b	 BIGROCK,      99,      99,      99, BIGROCK,      99,      99,  PROCKB,      99,      99,   BSTAR,      99, BIGROCK,      99, TRI_ALL,      99
	dc.b	      99, BIGROCK,      99,      99, MEDROCK,      99, BUBBLEB, BIGCRYS,   BSTAR,      99, BURPLEB,  PROCKB, TRI_ALL,   BSTAR,    CUBE, BIGCRYS
	dc.b	      99,      99, BIGROCK, PEBBLEB,      99, BIGROCK,    CUBE,      99, BURPLEB, BIGROCK,      99,   BSTAR,  PROCKB,      99, BIGROCK,      99
	dc.b	 PEBBLEM, BIGROCK,   BSTAR, BIGROCK, BUBBLEB,    CUBE,   BSTAR,      99, BIGCRYS,      99, BURPLEB,      99, TRI_ALL, PEBBLEB, PEBBLEM, BIGROCK
	dc.b	 TRI_ALL, BIGROCK,      99,   BSTAR,   BSTAR,      99, BIGCRYS, BIGCRYS, BIGROCK, BIGROCK,   BSTAR, TRI_ALL, BIGROCK,      99, BIGROCK,      99
	dc.b	 MEDROCK,      99, PEBBLEB,      99,   BSTAR,      99, BIGROCK,   BSTAR,    CUBE,  PROCKB,      99, BIGROCK,      99,      99, BIGCRYS, TRI_ALL
	dc.b	 BIGROCK,      99,      99, BIGCRYS, BURPLEB, BIGROCK,   BSTAR, BIGROCK,      99, PEBBLEB, BIGCRYS, BIGROCK,      99,      99, BIGROCK, BUBBLEB
	dc.b	   BSTAR, BIGROCK,      99,   MSTAR,  PROCKB, BIGROCK,      99,      99, BURPLEB, BIGROCK,   BSTAR, BIGROCK, TRI_ALL,      99, BIGROCK, PEBBLEB
	dc.b	      99,      99, BIGROCK, BIGROCK,   BSTAR,      99,      99, MEDROCK,  PROCKB, BIGROCK,      99, BIGROCK, PEBBLEB,      99, BIGCRYS,      99
	dc.b	 BIGROCK,   BSTAR, BIGROCK,      99,   BSTAR,      99, BIGROCK, BIGCRYS, TRI_ALL, BIGCRYS,    CUBE,      99, TRI_ALL, BUBBLEB,      99, BIGROCK
	dc.b	 PEBBLEM, BIGROCK,    CUBE,      99,  PROCKM,   BSTAR, PEBBLEB, BIGROCK, BIGROCK, BIGCRYS,      99, BIGCRYS,      99,   BSTAR, BIGROCK,   BSTAR
	dc.b	 BIGROCK, BIGROCK, TRI_ALL,      99,      99, BIGROCK, BURPLEB, BIGROCK,      99,  PROCKB,      99, PEBBLEB,      99, MEDROCK,   MSTAR,   BSTAR
	dc.b	 TRI_ALL,   BSTAR, BIGROCK,      99, BIGROCK, BURPLEB, BIGCRYS, BIGROCK,   BSTAR, BIGROCK, BUBBLEB,   BSTAR,      99,      99,    CUBE,      99
	dc.b	   BSTAR, BIGROCK,  PROCKB,      99,      99, PEBBLEB, BIGROCK, BIGROCK, BIGROCK,      99, BIGCRYS,      99, BIGCRYS, BIGROCK,      99, TRI_ALL
	dc.b	   BSTAR,      99,   BSTAR, BIGROCK, BIGROCK,      99,      99, BIGROCK,  PROCKB,   BSTAR, PEBBLEB,      99, BIGCRYS, BIGROCK, MEDROCK,      99
	dc.b	 BIGROCK,      99, BIGROCK, BIGROCK,      99,      99,    CUBE, BUBBLEB,      99, TRI_ALL, TRI_ALL,      99,      99, PEBBLEB,  PROCKM,   BSTAR
	dc.b	 BIGROCK, TRI_ALL, BIGROCK,      99, PEBBLEM, BIGCRYS,   BSTAR, BIGROCK, BIGROCK,      99,      99, BIGROCK, BURPLEB,      99,   BSTAR, BIGROCK
	dc.b	 BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB, BIGROCK,  PROCKB
	dc.b	 MEDROCK,      99,      99, BIGROCK,   BSTAR,    CUBE, PEBBLEB,      99,  PROCKB, BIGROCK, BUBBLEB,      99, BIGCRYS,      99,      99,   BSTAR
	dc.b	 BIGROCK,   BSTAR,      99,      99, BIGROCK,      99,      99, BIGROCK,   BSTAR, BIGROCK, BIGROCK,   BSTAR,      99,      99,      99, BIGROCK
	dc.b	 BURPLEB, BURPLEB, BURPLEB, BURPLES, BURPLEB, BURPLEB,  PROCKB, PEBBLEB, TRI_ALL,      99, BIGROCK, BIGROCK,      99, PEBBLEM,      99, BIGROCK
	dc.b	      99,   BSTAR, BIGROCK,   BSTAR, TRI_ALL,      99, BURPLEB, BURPLEB, BURPLEB, PEBBLEB,   MSTAR,      99, BIGCRYS, TRI_ALL,      99, MEDROCK
	dc.b	 BIGROCK, BIGCRYS,      99,      99,      99,    CUBE,   BSTAR,      99, BUBBLEB, BIGROCK,      99, BIGROCK,    CUBE,      99,      99,   BSTAR
	dc.b	 BIGROCK,      99,      99, PEBBLEB,      99,      99,      99, BIGCRYS,      99, TRI_ALL,   BSTAR,      99,  PROCKB, BIGROCK,  PROCKM,      99
	dc.b	 BIGCRYS, BIGROCK,   BSTAR,      99,   BSTAR, BURPLEB, BIGROCK, BIGROCK,      99, BURPLEB, BURPLEB, BIGROCK, PEBBLEM,      99, PEBBLEB, BIGROCK
	dc.b	      99,      99, BIGROCK,      99, TRI_ALL,   BSTAR,      99,  PROCKB, BIGCRYS,      99,      99,   BSTAR,      99,      99, BIGROCK, BIGCRYS
	dc.b	      99, BIGROCK,   BSTAR, MEDROCK,   MSTAR,      99, TRI_ALL,      99, BIGROCK, PEBBLEB,      99,      99, BUBBLEB,      99,   BSTAR, BIGROCK
	dc.b	 BIGCRYS,      99,  PROCKB,      99,      99, BIGROCK, BIGROCK, BIGROCK,      99, BIGCRYS,  PROCKM,      99, TRI_ALL,      99,      99, BIGROCK
	dc.b	      99,      99,      99,   BSTAR,      99, BIGROCK, PEBBLEB,   BSTAR, PEBBLEM,      99, TRI_ALL,      99, BIGCRYS,      99, BIGCRYS, BIGROCK
	dc.b	 BIGROCK,      99,      99, BURPLEB,      99,      99,      99,   BSTAR,      99,      99, BIGROCK,      99, BIGCRYS,      99, BIGROCK,    CUBE
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,   BSTAR, PEBBLEB, BUBBLEB, BUBBLEB,    CUBE,  PROCKM, BIGROCK, BIGROCK,      99, BUBBLEB, BUBBLEB, BUBBLEB
	dc.b	 TRI_ALL, BUBBLEB, BUBBLEB, BUBBLEB,      99,  PROCKB,      99,      99,   BSTAR, TRI_ALL, BIGROCK,      99,      99,      99, BIGROCK,      99
	dc.b	 BIGROCK,   BSTAR,      99,      99,      99, BIGCRYS, PEBBLEM,      99, BUBBLEB,   BSTAR, PEBBLEB, BIGCRYS,      99,   BSTAR,      99,      99
 	dc.b	      99, BIGROCK,      99,  PROCKB, BIGROCK,      99, BIGROCK,      99,      99,      99, BIGROCK,      99, TRI_ALL,   MSTAR,  PROCKM,      99
	dc.b	      99, BIGROCK, BIGROCK,    CUBE, BIGROCK, TRI_ALL,      99,    CUBE,      99, TRI_ALL,   BSTAR,      99, BIGROCK, BIGROCK,      99,      99
	dc.b	 BIGROCK, BIGROCK,      99, BUBBLEB, BIGROCK,  PROCKB,  PROCKM, BURPLEB,   MSTAR,      99,      99,      99, PEBBLEB,      99, BIGROCK,      99
	dc.b	 BIGROCK, BIGCRYS,      99, BIGCRYS,      99, BIGROCK,      99,   BSTAR,      99, BIGCRYS, BIGROCK,      99,      99, BIGROCK,      99, TRI_ALL
	dc.b	      99, BIGCRYS,      99,      99,      99, PEBBLEM,  PROCKB,   BSTAR,      99, TRI_ALL, MEDROCK,      99,      99,      99, BIGROCK, PEBBLEB
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLEB
	dc.b	 BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB
	dc.b	      99,      99,   BSTAR,      99, BIGROCK,      99, BUBBLEB,      99,      99, PEBBLEM, BIGCRYS,      99, BURPLEB,      99, BIGROCK,      99
	dc.b	 PEBBLEB,      99,      99,   BSTAR,   BSTAR,  PROCKB, BIGCRYS, BIGROCK,  PROCKM,   BSTAR, BIGCRYS,      99, BIGCRYS,      99,      99, BIGROCK
	dc.b	      99,    CUBE,      99,      99,   BSTAR,      99, BIGROCK,   BSTAR,      99,      99, BIGROCK, BIGROCK,   MSTAR,      99, BIGCRYS,      99
	dc.b	      99,    CUBE,      99, BIGCRYS,      99, BIGROCK,   BSTAR, MEDROCK, TRI_ALL,      99, PEBBLEB,      99, TRI_ALL, TRI_ALL,      99, BIGROCK
	dc.b	 BIGROCK,      99, BIGROCK, BIGROCK,      99, PEBBLEM,      99,      99,   BSTAR,      99, BUBBLEB, BIGROCK,      99, BIGROCK,      99, BIGCRYS
	dc.b	  PROCKB,   BSTAR,      99,      99,   BSTAR,  PROCKM,      99, BIGROCK,      99,      99,      99, PEBBLEB,      99, BIGROCK,      99,   BSTAR
	dc.b	      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99
	dc.b	      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99
	dc.b	      99, BURPLEB,      99,      99,      99,      99,      99,      99,      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99
	dc.b	      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99,      99, BURPLEB,      99,      99
	dc.b	      99, BURPLEB,      99,      99,   BSTAR,      99,  PROCKB,      99,      99,      99,  PROCKB,      99,      99,      99, BIGCRYS,      99
	dc.b	      99, BIGROCK,      99, BIGCRYS,      99, BURPLEB,      99,    CUBE, BIGROCK, BURPLEB,      99, BIGROCK,      99,   BSTAR,   MSTAR, BIGCRYS
	dc.b	  PROCKB,   BSTAR,      99,      99, BIGROCK, BIGROCK,      99, PEBBLEB,   BSTAR,      99, BUBBLEB,      99,      99,      99,      99,   BSTAR
	dc.b	   BSTAR,      99, BIGCRYS, PEBBLEM,      99,      99, MEDROCK, BIGROCK,      99,   BSTAR, BIGROCK,   BSTAR,      99,      99,    CUBE,  PROCKM
	dc.b	 BIGCRYS, BIGROCK,      99,      99, BIGROCK,      99,      99,   BSTAR,      99,      99,  PROCKB,   BSTAR,      99,      99,      99, BIGCRYS
	dc.b	 MEDROCK, BIGCRYS,      99,      99,      99,   MSTAR,      99,   BSTAR, BIGROCK,      99, BURPLEB, BIGROCK, PEBBLEB,    CUBE,  PROCKB,      99
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB,  PROCKM, PEBBLEM, BUBBLEB,    CUBE,   BSTAR, BIGROCK,      99,      99, BIGCRYS,      99, BIGROCK,   BSTAR
	dc.b	      99,      99, BIGROCK,      99, BIGROCK,      99,   BSTAR,      99, BIGCRYS,      99,      99, BIGROCK, BIGROCK,      99,  PROCKB,      99
	dc.b	      99, BIGROCK,      99,      99,      99,   BSTAR, BIGROCK,      99, BIGCRYS,    CUBE,      99,   BSTAR,      99,      99, BIGROCK,      99
	dc.b	      99,      99, PEBBLEB,      99, BIGROCK,  PROCKM,  PROCKB, PEBBLEM, BUBBLEB, BIGCRYS, TRI_ALL, BURPLEB,      99, BIGROCK, MEDROCK,      99
	dc.b	      99, BIGROCK,      99,   BSTAR, BIGROCK, BIGROCK, TRI_ALL,   BSTAR,      99,      99, BIGROCK,    CUBE, BIGCRYS,      99,      99,      99
	dc.b	 PEBBLEB,      99,      99,      99, BIGROCK,      99,      99,   BSTAR, BIGROCK, MEDROCK, TRI_ALL,      99, BIGCRYS, BIGROCK, BIGROCK,      99
	dc.b	 TRI_ALL,      99, BIGCRYS,      99,   BSTAR, BIGROCK, BUBBLEB,      99, BIGCRYS,      99, PEBBLEB,      99, BIGROCK, MEDROCK,      99,   BSTAR
	dc.b	 BIGROCK,      99, BIGROCK, BIGROCK,      99, BIGROCK,      99, BIGROCK,      99,      99,      99,      99,      99,      99,      99,      99

;*****************************************************************************************************
tlistsp4::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$04,$05,$00,$01,$02,$0D,$00,$04,$05,$06,$02,$0D,$03,$04,$01,$09,$0C,$00,$04,$01,$09,$0D,$06,$07,$02,$0A,$03,$04,$01,$02,$03
	dc.b	$01,$09,$00,$04,$05,$0C,$0A,$00,$01,$08,$09,$00,$01,$08,$07,$02,$00,$04,$01,$09,$0B,$0C,$03,$04,$01,$07,$02,$0B,$0C,$0A,$03,$05
	dc.b	$03,$01,$09,$03,$01,$07,$08,$09,$0C,$00,$01,$09,$0C,$00,$05,$0C,$00,$01,$07,$02,$0B,$0D,$0C,$06,$07,$09,$0D,$00,$04,$01,$08,$09
	dc.b	$06,$09,$0C,$0A,$06,$09,$06,$02,$00,$05,$0B,$0D,$00,$04,$05,$06,$02,$03,$01,$09,$0C,$03,$01,$07,$08,$02,$0A,$06,$07,$09,$00,$04
	dc.b	$05,$03,$04,$01,$07,$02,$0A,$0D,$00,$01,$09,$00,$04,$01,$09,$0C,$0B,$00,$04,$01,$07,$09,$00,$01,$07,$09,$0C,$06,$07,$02,$0A,$00
	dc.b	$04,$01,$08,$09,$00,$04,$05,$0C,$0D,$03,$05,$0A,$00,$04,$05,$06,$08,$02,$06,$08,$07,$02,$0C,$03,$01,$08,$09,$0C,$0D,$0C,$06,$02
	dc.b	$06,$08,$09,$0C,$0A,$0C,$0A,$03,$01,$07,$02,$00,$05,$06,$08,$07,$09,$0B,$0D,$0A,$03,$05,$0D,$06,$08,$07,$09,$0D,$00,$05,$06,$07
	dc.b	$08,$09,$06,$08,$09,$0B,$0C,$0B,$0D,$00,$01,$02,$00,$01,$08,$09,$0A,$06,$02,$0C,$03,$04,$01,$02,$0D,$0C,$0A,$0D,$00,$01,$08,$07
;end of space level
	dc.b	$02,$03,$05,$0C,$0A,$00,$01,$07,$08,$02,$03,$04,$05,$0B,$00,$01,$07,$08,$09,$03,$05,$0D,$0B,$00,$04,$01,$02,$0C,$0A,$03,$04,$01
	dc.b	$08,$09,$06,$07,$09,$0C,$0A,$03,$04,$05,$0C,$0D,$0C,$03,$01,$07,$08,$07,$02,$03,$04,$01,$07,$09,$0C,$00,$04,$05,$03,$01,$08,$02
	dc.b	$0D,$06,$07,$08,$09,$0C,$0B,$0A,$06,$09,$0B,$0C,$0D,$03,$01,$02,$0A,$00,$04,$05,$03,$05,$03,$01,$02,$00,$04,$05,$0C,$00,$05,$0A

;enemies for space level 4			32 enemies per line
;99 means no enemy
;each byte is the enemy number to create at odomback / 16
;that makes 4 possible enemies for each tile
;table size is 1024 bytes (256 tiles per level * 4 enemies per tile)
;enemies that can be used:
;big rock
;big crystal
;big star
;purple rocks
;burple
;bubble
;pebble
;cube
;tri
elistsp4::
	dc.b	 BIGROCK,      99,      99,      99, BIGROCK,      99,      99,  PROCKB,      99,      99,   BSTAR,      99, BIGROCK,      99,      99, PEBBLEB
	dc.b	      99, BIGROCK, BIGCRYS,      99, MEDROCK,      99, BUBBLEB,      99,   BSTAR,      99, TRI_ALL,  PROCKB,      99,   BSTAR, BIGROCK, BIGCRYS
	dc.b	    CUBE,      99, BIGROCK, PEBBLEB,      99, BIGROCK,    CUBE,      99, BURPLEB, BIGROCK,  PROCKM,   BSTAR,  PROCKB, BIGCRYS, BIGROCK,      99
	dc.b	      99, BIGROCK,   BSTAR, MEDROCK,      99, BIGROCK,   BSTAR,      99, BIGCRYS,      99, TRI_ALL, BUBBLEB, BIGROCK, PEBBLEB,      99, BIGROCK
	dc.b	  PROCKB, BIGROCK,      99,   BSTAR,   BSTAR,      99, BIGCRYS, BIGCRYS, BIGROCK, BIGROCK,   BSTAR, TRI_ALL, BIGROCK,      99, MEDROCK,      99
	dc.b	 BIGROCK,      99, PEBBLEB,      99,   BSTAR,      99, BIGROCK,   BSTAR, BIGROCK,  PROCKB, PEBBLEM, BIGROCK, BUBBLES,      99, BIGCRYS, BIGROCK
	dc.b	 BIGROCK,      99,      99, BIGCRYS, TRI_ALL, BIGROCK,   BSTAR, MEDROCK, BUBBLEB, PEBBLEB, BIGCRYS, BIGROCK,      99,      99, BIGROCK, BUBBLEB
	dc.b	      99,      99, MEDROCK, BIGROCK,   BSTAR,      99,      99, BIGROCK,  PROCKB, BIGROCK,      99, BIGROCK, PEBBLEB, BUBBLEB, BIGCRYS,      99
	dc.b	 BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB, BIGROCK,  PROCKB
	dc.b	 PEBBLEB, BIGROCK, PEBBLEB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK
	dc.b	 PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB
	dc.b	  PROCKB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB
	dc.b	 BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK, PEBBLEB
	dc.b	 BIGROCK,  PROCKB, PEBBLEB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB
	dc.b	 PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB
	dc.b	 BIGROCK,  PROCKB, PEBBLEB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK,  PROCKB, PEBBLEB, BIGROCK, PEBBLEB
	dc.b	 BIGROCK,   BSTAR, BIGROCK, PEBBLEM,   BSTAR,      99, MEDROCK, BIGCRYS, BIGROCK, BIGCRYS, TRI_ALL,      99,  PROCKB, BUBBLEB,      99, BIGROCK
	dc.b	      99, MEDROCK, BIGROCK,      99,      99,   BSTAR, PEBBLEB, BIGROCK, BIGROCK, BIGCRYS, BUBBLES, BIGCRYS,      99,   BSTAR, BIGROCK,   BSTAR
	dc.b	 MEDROCK, BIGROCK,    CUBE,      99,      99, BIGROCK, BURPLEB, BIGROCK,      99,  PROCKB,      99, PEBBLEB,  PROCKM, BIGROCK, BUBBLEB,   BSTAR
	dc.b	   BSTAR, BIGROCK,  PROCKB, PEBBLEM,      99, PEBBLEB, MEDROCK, BIGROCK, BIGROCK,    CUBE, BIGCRYS,      99, BIGCRYS, BIGROCK,      99, BIGROCK
	dc.b	   BSTAR,      99,   BSTAR, BIGROCK, BIGROCK,      99,      99, TRI_ALL,  PROCKB,   BSTAR, PEBBLEB,      99, BIGCRYS, BIGROCK, BIGROCK, BUBBLEB
	dc.b	      99,   BSTAR,  PROCKB, BUBBLEB, PEBBLEB, BIGROCK,      99, BIGROCK, PEBBLEM, BIGROCK,      99, BIGROCK,   BSTAR,      99, BIGCRYS,      99
	dc.b	 BIGROCK,      99,    CUBE, BIGROCK,   BSTAR, TRI_ALL, PEBBLEB,      99,  PROCKB, BIGROCK, BUBBLEB,      99, BIGCRYS,  PROCKM,      99,   BSTAR
	dc.b	      99, BURPLEB, BUBBLEB,      99, BUBBLEB, BIGROCK,      99, BUBBLEB,      99, BURPLEB, BUBBLEB,      99, BUBBLEB, BIGROCK,      99, BUBBLEB
	dc.b	      99, BURPLEB,    CUBE,      99, BUBBLEB, BIGROCK,      99, BUBBLEB,      99, BURPLEB, BUBBLEB,      99, BUBBLEB, BIGROCK,      99, BUBBLEB
	dc.b	      99, BURPLEB, BUBBLEB,      99, BUBBLEB,      99, BUBBLEB,      99, BUBBLEB,    CUBE,      99, BUBBLEB,      99, BURPLEB, BUBBLEB,      99
	dc.b	 BUBBLEB,    CUBE,      99, BUBBLEB,      99, BURPLEB, BUBBLEB,      99, BUBBLEB,    CUBE,      99, BUBBLEB,      99, BURPLEB, BUBBLEB,      99
	dc.b	 BUBBLEB,    CUBE,      99,      99,   BSTAR,      99,  PROCKB,      99,      99,      99,  PROCKB,      99,      99,      99, BIGCRYS,      99
	dc.b	 BIGROCK,   BSTAR,      99,      99, BIGROCK,      99,      99, MEDROCK,   BSTAR, BIGROCK, BIGROCK,   BSTAR,      99,      99,      99,    CUBE
	dc.b	      99, BIGCRYS, BIGROCK,      99,      99, BURPLEB,  PROCKB, PEBBLEB, BIGROCK,      99, BIGROCK, BIGROCK,      99, PEBBLEM, BUBBLEB, BIGROCK
	dc.b	      99,   BSTAR, BIGROCK,   BSTAR, TRI_ALL,      99,  PROCKM,      99, BIGROCK, PEBBLEB, BUBBLES,      99, BIGCRYS,  PROCKB,      99, BIGROCK
	dc.b	 BIGROCK, BIGCRYS,      99,      99,      99, BIGROCK,   BSTAR,      99, BUBBLEB, MEDROCK,      99, BIGROCK, TRI_ALL,      99,      99,   BSTAR
	dc.b	 BIGROCK,      99,      99, PEBBLEB,      99,      99,      99, BIGCRYS,      99, BIGROCK,   BSTAR,      99,  PROCKB, BIGROCK, BUBBLEB,  PROCKM
	dc.b	 BIGCRYS, BIGROCK,   BSTAR,    CUBE,   BSTAR, BURPLEB, BIGROCK, BIGROCK, PEBBLEM,      99, TRI_ALL, BIGROCK,      99,      99, PEBBLEB, BIGROCK
	dc.b	      99,      99, BIGROCK,      99,      99,   BSTAR,      99,  PROCKB, BIGCRYS,      99,      99,   BSTAR,      99, BUBBLES, MEDROCK, BIGCRYS
	dc.b	 BURPLEB, BURPLEB, BURPLEB, BURPLES, BURPLEB, BURPLEB, BURPLEB, BURPLES, BURPLEB, BURPLEB, BURPLES, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB
	dc.b	 BURPLEB, BURPLEB, BURPLES, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLES, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLES, BURPLEB, BURPLEB
	dc.b	 BURPLEB, BURPLES, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLES, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLES, BURPLEB
	dc.b	 BUBBLEB,      99, BIGROCK,      99, BIGCRYS,    CUBE,      99, MEDROCK,      99, BUBBLES, BIGROCK,      99,  PROCKM,      99, BIGCRYS,      99
	dc.b	      99,      99,      99,      99, BIGROCK,      99,   BSTAR,      99,   BSTAR, BIGROCK,   BSTAR,      99,      99,      99,    CUBE, PEBBLEM
	dc.b	 BIGROCK,      99,   BSTAR,      99,  PROCKB,      99,      99, BIGCRYS, BUBBLEB,      99, BIGROCK,      99,   BSTAR, BIGROCK,  PROCKM, TRI_ALL
	dc.b	 BIGROCK,   BSTAR,      99,      99,      99, BIGCRYS,      99,      99, BUBBLEB,   BSTAR, PEBBLEB, BIGCRYS,      99,   BSTAR, BUBBLES,      99
 	dc.b	      99, BIGROCK,      99,  PROCKB, BIGROCK,      99, BIGROCK,      99,      99,      99, BIGROCK,      99, MEDROCK, PEBBLEM,      99,      99
	dc.b	      99,   BSTAR,      99,    CUBE,      99,      99,  PROCKM, BIGROCK, BIGROCK, BUBBLEB,  PROCKB,   BSTAR,      99,      99, BIGCRYS,    CUBE
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLEB
	dc.b	      99, BIGROCK, BIGROCK, TRI_ALL, BIGROCK,  PROCKB,      99, BIGROCK,      99, BIGROCK,   BSTAR,      99, BIGROCK, BIGROCK,      99,      99
	dc.b	 MEDROCK, BIGCRYS,      99, BIGCRYS,      99, BIGROCK,      99,   BSTAR,  PROCKM, BIGCRYS, BIGROCK,      99,      99, BIGROCK,      99, BIGROCK
	dc.b	      99, BIGCRYS,      99, BUBBLEB,      99,      99,  PROCKB,   BSTAR, BUBBLES, TRI_ALL, BIGROCK,      99,      99,    CUBE, BIGROCK, PEBBLEB
	dc.b	    CUBE,      99, BUBBLEB, BURPLEB,      99,   BSTAR,      99,  PROCKM, BIGCRYS,      99, BIGROCK,   BSTAR,    CUBE,      99, BIGROCK, BIGROCK
	dc.b	 BUBBLEB, BUBBLEB, BUBBLEB, BUBBLES, BUBBLEB, BUBBLEB, BUBBLEB, BUBBLES,      99,      99, BIGCRYS,      99, BURPLEB, BUBBLEB, BIGROCK,      99
	dc.b	 PEBBLEB,      99,      99,   BSTAR,   BSTAR,  PROCKB, BIGCRYS, MEDROCK,      99,   BSTAR, BIGCRYS,      99, BIGCRYS, PEBBLEM,      99, BIGROCK
	dc.b	      99, TRI_ALL,      99,      99,   BSTAR,      99, BIGROCK,   BSTAR,    CUBE,      99, BIGROCK, TRI_ALL,  PROCKM,      99, BIGCRYS,      99
	dc.b	 BUBBLES, BIGROCK,      99, BIGCRYS,      99, BIGROCK,   BSTAR, BIGROCK,  PROCKB,      99, PEBBLEB,      99, TRI_ALL, BIGROCK,      99, BIGROCK
	dc.b	 BIGROCK,      99, BIGROCK, BIGROCK,      99,      99,      99, BUBBLEB,   BSTAR,      99, BUBBLEB, BIGROCK, PEBBLEM,    CUBE,      99, BIGCRYS
	dc.b	 PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB,  PROCKB, BIGROCK, PEBBLEB
	dc.b	  PROCKB,   BSTAR, BUBBLEB,      99, BIGROCK, BIGROCK, BUBBLES, PEBBLEB,   BSTAR,      99, BUBBLEB, PEBBLEM,      99,      99,      99,   BSTAR
	dc.b	 BIGCRYS, BIGROCK,      99,  PROCKM, BIGROCK,      99,      99,   BSTAR,      99,      99,  PROCKB,   BSTAR,      99,      99,      99, BIGCRYS
	dc.b	      99, BIGROCK,      99,      99, BIGCRYS, PEBBLEM,   BSTAR, TRI_ALL, BUBBLEB,      99,      99,    CUBE, BIGROCK, PEBBLEB, BUBBLEB,      99
	dc.b	 BIGROCK,      99,      99, BUBBLES,   BSTAR,      99,      99, MEDROCK,      99, BIGROCK,   BSTAR,      99, BIGCRYS,      99, BIGROCK,  PROCKB
	dc.b	 BURPLEB, BURPLEB, BURPLEB, BURPLEB, BURPLEB,      99,   BSTAR, BUBBLEB, BIGCRYS,  PROCKM,      99, BIGROCK, BIGROCK,      99,  PROCKB,    CUBE
	dc.b	      99, BIGROCK,      99,   BSTAR, BIGROCK, BIGROCK,  PROCKB,   BSTAR, PEBBLEM,      99, BIGROCK, TRI_ALL, BIGCRYS,      99, BUBBLES,      99
	dc.b	 PEBBLEB,      99,      99,      99, BIGROCK,      99,  PROCKM,   BSTAR, BIGROCK, BIGROCK,  PROCKB,      99, BIGCRYS, BIGROCK, MEDROCK,      99
	dc.b	 TRI_ALL,      99, BIGCRYS,      99,   BSTAR, BIGROCK, BUBBLEB,      99, BIGCRYS,      99, PEBBLEB,      99, BIGROCK, BIGROCK,      99,   BSTAR
	dc.b	 BIGROCK,      99, BIGROCK, BIGROCK,      99, BIGROCK,      99, BIGROCK,      99,      99,      99,      99,      99,      99,      99,      99

;*****************************************************************************************************

;*****************************************************************************************************
tlistbn::
;*****************************************************************************************************
;background tiles
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
;end of bonus level
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01
	dc.b	$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01,$00,$01

;list of ground enemy/objects to create for each curbktile
glistbon::
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
	dc.b	$FF,$FF,$FF,$FF,RINGL0,$FF,$FF,$FF,$FF,RINGM0,$FF,$FF,$FF,$FF,RINGS0,$FF
;256

frinfbon::
;info for foreground objects
;data
	dc.l		ring01,ring03,ring05,0,0,0,0,0,0,0,0,0,0,0,0,0
;height
	dc.w		184,120,88,0,0,0,0,0,0,0,0,0,0,0,0,0
;width
	dc.w		128,96,64,0,0,0,0,0,0,0,0,0,0,0,0,0
;dwidth, iwidth
	dc.w		32,24,16,0,0,0,0,0,0,0,0,0,0,0,0,0
;ypos
	dc.w		0				;large ring
	dc.w		0				;medium ring
	dc.w		0				;small ring
	dc.w		0,0,0,0,0,0,0,0,0,0,0,0,0

